"use strict";async function addTags(t,e,s){const o=[];for(const t of e){if(!t.id)throw(0,error_1.createError)({statusCode:400,message:"Each tag object must have an id property"});const e=await db_1.models.tag.findByPk(t.id,{transaction:s});if(!e)throw(0,error_1.createError)({statusCode:400,message:`Tag with id ${t.id} not found`});o.push(e)}await db_1.models.postTag.bulkCreate(o.map(e=>({postId:t.id,tagId:e.id})),{transaction:s})}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Creates a new blog post",description:"This endpoint creates a new blog post.",operationId:"createPost",tags:["Content","Author","Post"],logModule:"BLOG",logTitle:"Create blog post",requiresAuth:!0,requestBody:{required:!0,description:"New blog post data",content:{"application/json":{schema:{type:"object",properties:{title:{type:"string",description:"Title of the post"},content:{type:"string",description:"Content of the post"},description:{type:"string",description:"Description of the post"},categoryId:{type:"string",description:"Category ID for the post"},status:{type:"string",description:"Status of the blog post",enum:["PUBLISHED","DRAFT"]},tags:{type:"array",description:"Array of tag objects associated with the post",items:{type:"object",properties:{id:{type:"string"}},required:["id"]}},slug:{type:"string",description:"Slug of the post"},image:{type:"string",description:"Image URL for the post"}},required:["title","content","categoryId","status","slug"]}}}},responses:{201:{description:"Blog post created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Confirmation message of successful post creation"}}}}}},401:{description:"Unauthorized, user must be authenticated"},409:{description:"Conflict, post with the same slug already exists"},500:{description:"Internal server error"}}};exports.default=async t=>{const{params:e,body:s,user:o,ctx:r}=t;if(!(null==o?void 0:o.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{content:i,tags:a,categoryId:n,description:d,title:c,status:p,slug:u,image:l}=s;null==r||r.step("Verifying author credentials");const g=await db_1.models.author.findOne({where:{userId:o.id}});if(!g)throw(0,error_1.createError)({statusCode:404,message:"Author not found"});return await db_1.sequelize.transaction(async t=>{null==r||r.step("Checking for duplicate post slug");if(await db_1.models.post.findOne({where:{slug:u,authorId:g.id},transaction:t}))throw(0,error_1.createError)({statusCode:409,message:"A post with the same slug already exists"});null==r||r.step("Creating blog post");const e=await db_1.models.post.create({title:c,content:i,description:d,status:p,slug:u,authorId:g.id,categoryId:n,image:l},{transaction:t});if(a){null==r||r.step("Adding tags to post");await addTags(e,a,t)}null==r||r.success(`Blog post created: "${c}" (${e.id}) by author ${g.id}`);return{message:"Post created successfully"}}).catch(t=>{null==r||r.fail("Failed to create blog post");throw t})};