"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),utils_1=require("../utils"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Resends email verification token",operationId:"resendEmailVerification",tags:["Auth"],description:"Resends email verification token to user's email address",requiresAuth:!1,logModule:"EMAIL",logTitle:"Resend verification email",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{email:{type:"string",format:"email",description:"User's email address"}},required:["email"]}}}},responses:{200:{description:"Verification email sent successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request (e.g., email already verified)"},404:{description:"User not found"}}};exports.default=async e=>{const{body:i,ctx:r}=e,{email:t}=i;try{null==r||r.step("Validating resend request");if(!t){null==r||r.fail("Email is required");throw(0,error_1.createError)({statusCode:400,message:"Email is required"})}null==r||r.step(`Looking up user: ${t}`);const e=await db_1.models.user.findOne({where:{email:t}});if(!e){null==r||r.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found with this email address"})}null==r||r.step("Checking email verification status");if(e.emailVerified){null==r||r.fail("Email already verified");throw(0,error_1.createError)({statusCode:400,message:"Email is already verified"})}const i=cache_1.CacheManager.getInstance();if(!("true"===await i.getSetting("verifyEmailStatus"))){null==r||r.fail("Email verification not enabled");throw(0,error_1.createError)({statusCode:400,message:"Email verification is not enabled on this platform"})}try{null==r||r.step("Sending verification email");await(0,utils_1.sendEmailVerificationToken)(e.id,e.email);null==r||r.success(`Verification email resent to ${t}`);return{message:"Verification email sent successfully. Please check your inbox."}}catch(e){null==r||r.fail("Failed to send verification email");throw(0,error_1.createError)({statusCode:500,message:"Failed to send verification email. Please try again later."})}}catch(e){null==r||r.fail(e.message||"Failed to resend verification email");throw e}};