"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.verifyEmailTokenQuery=exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),token_1=require("@b/utils/token"),utils_1=require("../utils");exports.metadata={summary:"Verifies the email with the provided token",operationId:"verifyEmailToken",tags:["Auth"],description:"Verifies the email with the provided token",requiresAuth:!1,logModule:"EMAIL",logTitle:"Email verification",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{token:{type:"string",description:"The email verification token"}},required:["token"]}}}},responses:{200:{description:"Email verified successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request (e.g., missing or invalid token)"},404:{description:"Token not found or expired"}}};exports.default=async e=>{const{body:i,ctx:r}=e,{token:t}=i;return(0,exports.verifyEmailTokenQuery)(t,r)};const verifyEmailTokenQuery=async(e,i)=>{try{null==i||i.step("Validating email verification token");if(!e){null==i||i.fail("Token is required");throw(0,error_1.createError)({statusCode:400,message:"Token is required"})}null==i||i.step("Verifying token");const r=await(0,token_1.verifyEmailCode)(e);if(!r){null==i||i.fail("Token not found or expired");throw(0,error_1.createError)({statusCode:404,message:"Token not found or expired"})}null==i||i.step("Looking up user");const t=await db_1.models.user.findByPk(r);if(!t){null==i||i.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==i||i.step("Updating email verification status");await t.update({emailVerified:!0});null==i||i.step("Generating session tokens");const o=await(0,utils_1.returnUserWithTokens)({user:t,message:"Email verified successfully"});null==i||i.success(`Email verified for user ${t.email}`);return o}catch(e){null==i||i.fail(e.message||"Email verification failed");throw e}};exports.verifyEmailTokenQuery=verifyEmailTokenQuery;