"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const token_1=require("@b/utils/token"),db_1=require("@b/db"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),pow_captcha_1=require("@b/utils/pow-captcha");exports.metadata={summary:"Initiates a password reset process for a user",operationId:"resetPassword",tags:["Auth"],description:"Initiates a password reset process for a user and sends an email with a reset link",requiresAuth:!1,logModule:"PASSWORD",logTitle:"Password reset request",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{email:{type:"string",format:"email",description:"Email of the user"},powSolution:{type:"object",description:"Proof-of-work solution if enabled",nullable:!0,properties:{challenge:{type:"string"},nonce:{type:"number"},hash:{type:"string"}}}},required:["email"]}}}},responses:{200:{description:"Password reset process initiated successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"boolean",description:"Indicates if the request was successful"},statusCode:{type:"number",description:"HTTP status code",example:200},data:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}}}},400:{description:"Invalid request (e.g., missing email)"},404:{description:"User not found with the provided email"}}};exports.default=async e=>{const{body:s,ctx:t}=e,{email:r,powSolution:a}=s;try{null==t||t.step("Validating password reset request");if(!r){null==t||t.fail("Email is required");throw(0,error_1.createError)({statusCode:400,message:"Email is required"})}null==t||t.step("Verifying security challenge");try{await(0,pow_captcha_1.verifyPowOrThrow)(a,"reset")}catch(e){null==t||t.fail("Security verification failed");throw(0,error_1.createError)({statusCode:400,message:e instanceof Error?e.message:"Security verification failed"})}null==t||t.step(`Looking up user: ${r}`);const e=await db_1.models.user.findOne({where:{email:r}});if(!e){null==t||t.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==t||t.step("Generating password reset token");const s=await(0,token_1.generateResetToken)({user:{id:e.id}});try{null==t||t.step("Sending password reset email");await emails_1.emailQueue.add({emailData:{TO:e.email,FIRSTNAME:e.firstName,LAST_LOGIN:e.lastLogin,TOKEN:s},emailType:"PasswordReset"});null==t||t.success(`Password reset email sent to ${r}`);return{message:"Email with reset instructions sent successfully"}}catch(e){null==t||t.fail("Failed to send password reset email");throw(0,error_1.createError)({message:e.message,statusCode:500})}}catch(e){null==t||t.fail(e.message||"Password reset request failed");throw e}};