"use strict";async function verifyGoogleIdToken(e){try{const r=(await client.verifyIdToken({idToken:e,audience:CLIENT_ID})).getPayload();if(!r)throw(0,error_1.createError)({statusCode:401,message:"Missing payload in Google ID token"});if(!r.iss||!EXPECTED_ISSUERS.includes(r.iss))throw(0,error_1.createError)({statusCode:401,message:"Invalid issuer in Google ID token"});if(!r.aud||r.aud!==CLIENT_ID)throw(0,error_1.createError)({statusCode:401,message:"Invalid audience in Google ID token"});if(!r.exp||Date.now()/1e3>r.exp)throw(0,error_1.createError)({statusCode:401,message:"Google ID token has expired"});if(!r.sub||!r.email)throw(0,error_1.createError)({statusCode:401,message:"Invalid Google ID token: missing user info"});return r}catch(e){throw(0,error_1.createError)({statusCode:401,message:`Google authentication failed: ${e.message}`})}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const google_auth_library_1=require("google-auth-library"),db_1=require("@b/db"),query_1=require("@b/utils/query"),utils_1=require("../utils"),error_1=require("@b/utils/error"),CLIENT_ID=process.env.NEXT_PUBLIC_GOOGLE_CLIENT_ID,EXPECTED_ISSUERS=["accounts.google.com","https://accounts.google.com"],client=new google_auth_library_1.OAuth2Client(CLIENT_ID);exports.metadata={summary:"Logs in a user with Google",operationId:"loginUserWithGoogle",tags:["Auth"],description:"Logs in a user using Google and returns a session token",requiresAuth:!1,logModule:"LOGIN",logTitle:"Google login",requestBody:{required:!0,content:{"application/json":{schema:utils_1.userRegisterSchema}}},responses:{200:{description:"User logged in successfully",content:{"application/json":{schema:{type:"object",properties:utils_1.userRegisterResponseSchema}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{body:r,ctx:o}=e,{token:s}=r;try{null==o||o.step("Validating Google token");if(!s){null==o||o.fail("Missing Google token");throw(0,error_1.createError)({statusCode:400,message:"Missing Google token"})}null==o||o.step("Verifying Google ID token");let e;try{e=await verifyGoogleIdToken(s)}catch(e){null==o||o.fail("Invalid Google token");throw(0,error_1.createError)({statusCode:401,message:e.message||"Invalid Google token"})}const{sub:r,email:t,given_name:a,family_name:i}=e;null==o||o.step("Validating Google user data");if(!(r&&t&&a&&i)){null==o||o.fail("Incomplete user information from Google");throw(0,error_1.createError)({statusCode:400,message:"Incomplete user information from Google"})}null==o||o.step(`Looking up user: ${t}`);const n=await db_1.models.user.findOne({where:{email:t}});if(!n){null==o||o.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found. Please register first."})}null==o||o.step("Validating user status");if("BANNED"===n.status){null==o||o.fail("Account banned");throw(0,error_1.createError)({statusCode:403,message:"Your account has been banned. Please contact support."})}if("SUSPENDED"===n.status){null==o||o.fail("Account suspended");throw(0,error_1.createError)({statusCode:403,message:"Your account is suspended. Please contact support."})}if("INACTIVE"===n.status){null==o||o.fail("Account inactive");throw(0,error_1.createError)({statusCode:403,message:"Your account is inactive. Please verify your email or contact support."})}null==o||o.step("Checking Google provider link");if(!await db_1.models.providerUser.findOne({where:{providerUserId:r,provider:"GOOGLE"}})){null==o||o.step("Creating Google provider link");await db_1.models.providerUser.create({provider:"GOOGLE",providerUserId:r,userId:n.id})}null==o||o.step("Generating session tokens");const l=await(0,utils_1.returnUserWithTokens)({user:n,message:"You have been logged in successfully"});null==o||o.success(`User ${t} logged in with Google`);return l}catch(e){null==o||o.fail(e.message||"Google login failed");throw e}};