"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.loginUserChat=exports.metadata=void 0;const error_1=require("@b/utils/error"),passwords_1=require("@b/utils/passwords"),db_1=require("@b/db"),utils_1=require("../utils");exports.metadata={summary:"Logs in a user to the chat service",description:"Logs in a user to the chat service and returns a session token",operationId:"loginUserChat",tags:["Auth"],requiresAuth:!1,parameters:[{in:"query",name:"email",required:!0,schema:{type:"string",format:"email"},description:"Email of the user"},{in:"query",name:"password",required:!0,schema:{type:"string"},description:"Password of the user"},{in:"query",name:"firstName",required:!0,schema:{type:"string"},description:"First name of the user"},{in:"query",name:"lastName",required:!0,schema:{type:"string"},description:"Last name of the user"}],responses:{200:{description:"User logged into chat successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},cookies:{type:"object",properties:{accessToken:{type:"string",description:"Access token"}}}}}}}},400:{description:"Invalid request (e.g., missing or invalid email/password)"},401:{description:"Unauthorized (incorrect credentials)"}}};exports.default=e=>{const{query:s}=e,{email:r,password:t,firstName:a,lastName:o}=s;return(0,exports.loginUserChat)(r,t,a,o)};const loginUserChat=async(e,s,r,t)=>{if(!(0,utils_1.validateEmail)(e)||!(0,passwords_1.validatePassword)(s))throw(0,error_1.createError)({statusCode:400,message:"Invalid email or password"});const a=await(0,passwords_1.hashPassword)(s),o=await db_1.models.user.findOne({where:{email:e},include:{model:db_1.models.twoFactor,as:"twoFactor"}});if(o){if("BANNED"===o.status)throw(0,error_1.createError)({statusCode:403,message:"Your account has been banned. Please contact support."});if("SUSPENDED"===o.status)throw(0,error_1.createError)({statusCode:403,message:"Your account is suspended. Please contact support."});if("INACTIVE"===o.status)throw(0,error_1.createError)({statusCode:403,message:"Your account is inactive. Please verify your email or contact support."});await(0,utils_1.updateUser)(o.id,{firstName:r,lastName:t,hashedPassword:a});return await(0,utils_1.createSessionAndReturnResponse)(o)}{const s=await(0,utils_1.getOrCreateUserRole)(),o=await(0,utils_1.createUser)({firstName:r,lastName:t,email:e,hashedPassword:a,role:s});return await(0,utils_1.createSessionAndReturnResponse)(o)}};exports.loginUserChat=loginUserChat;