"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={summary:"Migrate ECO Transaction Reference IDs",operationId:"migrateEcoTransactions",tags:["Admin","System","Upgrade"],description:"Migrates ECO wallet transactions by moving referenceId values to trxId field and setting referenceId to null.",responses:{200:{description:"Migration completed successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean",description:"Whether the migration was successful"},updated:{type:"number",description:"Number of transactions updated"},message:{type:"string",description:"Migration result message"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Migrate ECO transactions"};exports.default=async e=>{const{user:r,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==s||s.step("Finding ECO transactions with referenceId");const[e]=await db_1.models.transaction.update({trxId:(0,sequelize_1.col)("referenceId"),referenceId:null},{where:{type:"ECO",referenceId:{[sequelize_1.Op.ne]:null}}});null==s||s.success(`Successfully migrated ${e} ECO transactions`);return{success:!0,updated:e,message:`Successfully migrated ${e} ECO transactions`}}catch(e){console_1.logger.error("SYSTEM","Error migrating ECO transactions",e);null==s||s.fail(`Failed to migrate ECO transactions: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:"Failed to migrate ECO transactions"})}};