"use strict";function getPublicDir(){if("production"===process.env.NODE_ENV){const e=[path_1.default.join(process.cwd(),"frontend","public"),path_1.default.join(process.cwd(),"public"),path_1.default.join(process.cwd(),"..","frontend","public")];for(const t of e)if(fs_1.default.existsSync(t))return t;return e[0]}return path_1.default.join(process.cwd(),"..","frontend","public")}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),promises_1=__importDefault(require("fs/promises")),fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),sharp_1=__importDefault(require("sharp"));exports.metadata={summary:"Upload PWA screenshot or splash screen",operationId:"uploadPwaScreenshot",tags:["Admin","System","PWA"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{file:{type:"string",description:"Base64 encoded image data"},type:{type:"string",enum:["screenshot","splash"],description:"Type of image to upload"},name:{type:"string",description:"Filename for the image (without extension)"},width:{type:"number",description:"Target width (optional, for resizing)"},height:{type:"number",description:"Target height (optional, for resizing)"},formFactor:{type:"string",enum:["wide","narrow"],description:"Form factor for screenshots"}},required:["file","type","name"]}}}},responses:{200:{description:"Screenshot uploaded successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},path:{type:"string"},sizes:{type:"string"}}}}}},400:{description:"Invalid file data"},500:{description:"Internal server error"}},permission:"edit.settings",requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Upload PWA screenshot"};exports.default=async e=>{const{body:t,ctx:r}=e,{file:s,type:o,name:i,width:a,height:n,formFactor:p}=t;if(!s||!o||!i)throw(0,error_1.createError)({statusCode:400,message:"File, type, and name are required"});if(!s.startsWith("data:"))throw(0,error_1.createError)({statusCode:400,message:"Invalid file format. Expected base64 data URI."});try{null==r||r.step(`Processing ${o} upload: ${i}`);const e=getPublicDir(),t="screenshot"===o?path_1.default.join(e,"img","screenshots"):path_1.default.join(e,"img","splash");fs_1.default.existsSync(t)||await promises_1.default.mkdir(t,{recursive:!0});const l=s.split(",")[1];if(!l)throw(0,error_1.createError)({statusCode:400,message:"Invalid file data"});const c=Buffer.from(l,"base64");let d=(0,sharp_1.default)(c);const u=await d.metadata();let f=u.width||0,h=u.height||0;if(a&&n){d=d.resize(a,n,{fit:"cover",position:"center"});f=a;h=n}const m=i.replace(/[^a-zA-Z0-9-_]/g,"_"),g=path_1.default.join(t,`${m}.png`),_=path_1.default.join(t,`${m}.webp`);await d.clone().png({compressionLevel:6}).toFile(g);await d.clone().webp({quality:90}).toFile(_);const y=`/img/${"screenshot"===o?"screenshots":"splash"}/${m}.png`,w=`${f}x${h}`;console_1.logger.info("PWA",`${o} uploaded: ${y} (${w})`);null==r||r.success(`${o} uploaded successfully`);return{message:`${o} uploaded successfully`,path:y,sizes:w,formFactor:p||(f>h?"wide":"narrow")}}catch(e){console_1.logger.error("PWA",`Failed to upload ${o}`,e);null==r||r.fail(`Failed to upload ${o}: ${null==e?void 0:e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to upload ${o}: ${null==e?void 0:e.message}`})}};