"use strict";function getManifestPath(){if("production"===process.env.NODE_ENV){const e=[path_1.default.join(process.cwd(),"frontend","public","manifest.json"),path_1.default.join(process.cwd(),"public","manifest.json"),path_1.default.join(process.cwd(),"..","frontend","public","manifest.json")];for(const t of e)if(fs_1.default.existsSync(t))return t;return e[0]}return path_1.default.join(process.cwd(),"..","frontend","public","manifest.json")}function getWebManifestPath(){if("production"===process.env.NODE_ENV){const e=[path_1.default.join(process.cwd(),"frontend","public","site.webmanifest"),path_1.default.join(process.cwd(),"public","site.webmanifest"),path_1.default.join(process.cwd(),"..","frontend","public","site.webmanifest")];for(const t of e)if(fs_1.default.existsSync(t))return t;return e[0]}return path_1.default.join(process.cwd(),"..","frontend","public","site.webmanifest")}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),promises_1=__importDefault(require("fs/promises")),fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path"));exports.metadata={summary:"Update PWA manifest configuration",operationId:"updatePwaManifest",tags:["Admin","System","PWA"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{manifest:{type:"object",description:"Complete manifest object to save"}},required:["manifest"]}}}},responses:{200:{description:"PWA manifest updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Invalid manifest data"},500:{description:"Internal server error"}},permission:"edit.settings",requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Update PWA manifest"};exports.default=async e=>{const{body:t,ctx:s}=e,{manifest:r}=t;if(!r||"object"!=typeof r)throw(0,error_1.createError)({statusCode:400,message:"Invalid manifest data"});try{null==s||s.step("Validating manifest structure");if(!r.name||!r.short_name)throw(0,error_1.createError)({statusCode:400,message:"Manifest must have name and short_name"});const e=["fullscreen","standalone","minimal-ui","browser"];if(r.display&&!e.includes(r.display))throw(0,error_1.createError)({statusCode:400,message:`Invalid display mode. Must be one of: ${e.join(", ")}`});const t=["any","natural","landscape","landscape-primary","landscape-secondary","portrait","portrait-primary","portrait-secondary"];if(r.orientation&&!t.includes(r.orientation))throw(0,error_1.createError)({statusCode:400,message:`Invalid orientation. Must be one of: ${t.join(", ")}`});const a=/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/;if(r.background_color&&!a.test(r.background_color))throw(0,error_1.createError)({statusCode:400,message:"Invalid background_color format. Use hex format (e.g., #ffffff)"});if(r.theme_color&&!a.test(r.theme_color))throw(0,error_1.createError)({statusCode:400,message:"Invalid theme_color format. Use hex format (e.g., #000000)"});null==s||s.step("Writing manifest files");const o=getManifestPath(),i=getWebManifestPath(),n=path_1.default.dirname(o);fs_1.default.existsSync(n)||await promises_1.default.mkdir(n,{recursive:!0});const f=JSON.stringify(r,null,2);await promises_1.default.writeFile(o,f,"utf-8");await promises_1.default.writeFile(i,f,"utf-8");console_1.logger.info("PWA",`Manifest updated at ${o}`);null==s||s.success("PWA manifest updated successfully");return{message:"PWA manifest updated successfully"}}catch(e){console_1.logger.error("PWA","Failed to update PWA manifest",e);null==s||s.fail(`Failed to update PWA manifest: ${null==e?void 0:e.message}`);if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:`Failed to update PWA manifest: ${null==e?void 0:e.message}`})}};