"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),errors_1=require("@b/utils/schema/errors"),db_1=require("@b/db");exports.metadata={summary:"Test Push Notification",description:"Send a test push notification to verify the push channel is configured correctly",operationId:"testPushNotification",tags:["Admin","Notification","Testing"],requiresAuth:!0,permission:"access.notification.settings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{userId:{type:"string",description:"User ID to send test notification to (defaults to current user)"}}}}}},responses:{200:{description:"Test push notification sent successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},notificationId:{type:"string"},delivered:{type:"boolean"},providerInfo:{type:"object",properties:{fcmAvailable:{type:"boolean"},webPushAvailable:{type:"boolean"},userHasTokens:{type:"boolean"}}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var i,s,t,o,n;const{body:r,user:a,ctx:c}=e;try{null===(i=null==c?void 0:c.step)||void 0===i||i.call(c,"Checking push configuration");const e=r.userId||(null==a?void 0:a.id);if(!e)throw new Error("User ID is required");const n=notification_1.notificationService.getChannel("PUSH")||new notification_1.PushChannel,l=n.hasFCMProvider(),u=n.hasWebPushProvider(),d=await db_1.models.user.findByPk(e,{attributes:["settings"]}),p=(null==d?void 0:d.settings)||{},h=!!(p.pushTokens&&Object.keys(p.pushTokens).length>0||p.webPushSubscriptions&&p.webPushSubscriptions.length>0);if(!l&&!u)return{success:!1,message:"No push providers configured. Set VAPID_* or FCM_* environment variables.",delivered:!1,providerInfo:{fcmAvailable:l,webPushAvailable:u,userHasTokens:h}};if(!h)return{success:!1,message:"User has no push notification subscriptions. Enable push notifications in your browser first.",delivered:!1,providerInfo:{fcmAvailable:l,webPushAvailable:u,userHasTokens:!1}};null===(s=null==c?void 0:c.step)||void 0===s||s.call(c,"Sending test push notification");const f=await notification_1.notificationService.send({userId:e,type:"SYSTEM",channels:["PUSH"],data:{title:"Test Push Notification",message:"This is a test push notification from the notification service. If you received this, your push channel is working correctly!",testMode:!0,timestamp:(new Date).toISOString(),badge:1,link:"/user/profile?tab=notifications"},priority:"NORMAL",idempotencyKey:`test-push-${e}-${Date.now()}`});null===(t=null==c?void 0:c.success)||void 0===t||t.call(c,"Test push notification sent");const v=f.channelsFailed.includes("PUSH"),b=v&&(null===(o=f.errors)||void 0===o?void 0:o.PUSH)?f.errors.PUSH:v?"Failed to deliver push notification":void 0;return{success:f.success&&!v,message:v?b||"Failed to send test push notification":"Test push notification sent successfully",notificationId:f.notificationId,delivered:f.channelsDelivered.includes("PUSH"),channels:{delivered:f.channelsDelivered,failed:f.channelsFailed},providerInfo:{fcmAvailable:l,webPushAvailable:u,userHasTokens:h},errors:f.errors}}catch(e){null===(n=null==c?void 0:c.fail)||void 0===n||n.call(c,e.message);throw e}};