"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/admin/system/utils"),security_1=require("@b/utils/security"),Middleware_1=require("@b/handler/Middleware"),error_1=require("@b/utils/error");exports.metadata={summary:"Activates the license for a product",operationId:"activateProductLicense",tags:["Admin","System"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{productId:{type:"string",description:"Product ID whose license to activate (optional, auto-detected from package.json)"},purchaseCode:{type:"string",description:"Envato purchase code for the product"},envatoUsername:{type:"string",description:"Envato username of the purchaser (optional, auto-detected from purchase code)"},notificationEmail:{type:"string",description:"Optional email to receive update notifications"}},required:["purchaseCode"]}}}},responses:{200:{description:"License activated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Confirmation message indicating successful activation"},productId:{type:"string",description:"The product ID that was activated"}}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal server error"}},requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Activate license"};exports.default=async e=>{const{ctx:t}=e,{purchaseCode:i,envatoUsername:s,notificationEmail:r}=e.body;null==t||t.step("Validating license details");let a=e.body.productId;if(!a){const e=await(0,utils_1.getProduct)();a=e.productId||e.id}if(!i)throw(0,error_1.createError)({statusCode:400,message:"Purchase code is required"});null==t||t.step("Activating license with Envato");const c=s||"auto";try{const e=await(0,utils_1.activateLicense)(a,i,c,r);null==t||t.step("Revalidating security status");await security_1.SecurityManager.getInstance().revalidate();(0,Middleware_1.clearExtensionLicenseCache)();null==t||t.success("License activated successfully");return{success:!0,...e,productId:a}}catch(e){null==t||t.fail(`Activation failed: ${e.message}`);return{success:!1,message:e.message,productId:a}}};