"use strict";async function checkDatabase(){const e=Date.now();try{await db_1.models.user.count();const t=Date.now()-e;return{name:"Database",status:t>1e3?"warning":"up",message:t>1e3?`Connected but slow (${t}ms)`:`Connected (${t}ms)`,latency:t,critical:!0}}catch(t){return{name:"Database",status:"down",message:`Connection failed: ${(null==t?void 0:t.message)||"Unknown error"}`,latency:Date.now()-e,critical:!0}}}async function checkCache(){const e=Date.now();try{const t=redis_1.RedisSingleton.getInstance(),a=await Promise.race([t.ping(),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis ping timeout")),3e3))]),s=Date.now()-e;return"PONG"===a?{name:"Cache (Redis)",status:s>500?"warning":"up",message:s>500?`Connected but slow (${s}ms)`:`Connected (${s}ms)`,latency:s,critical:!1}:{name:"Cache (Redis)",status:"warning",message:"Redis connected but unexpected response",latency:s,critical:!1}}catch(e){const t=(null==e?void 0:e.message)||"";return t.includes("ECONNREFUSED")||t.includes("timeout")?{name:"Cache (Redis)",status:"unconfigured",message:"Redis not available (using in-memory cache)",critical:!1}:{name:"Cache (Redis)",status:"warning",message:`Redis error: ${t||"Unknown error"}`,critical:!1}}}async function checkEmail(){try{const e=process.env.APP_EMAILER||"nodemailer-service";let t=!1,a=e;switch(null==e?void 0:e.toLowerCase()){case"local":t=!0;a="Local (Sendmail)";break;case"nodemailer-smtp":t=!(!process.env.APP_NODEMAILER_SMTP_HOST||!process.env.APP_NODEMAILER_SMTP_SENDER);a="SMTP";break;case"nodemailer-service":t=!!(process.env.APP_NODEMAILER_SERVICE&&process.env.APP_NODEMAILER_SERVICE_SENDER&&process.env.APP_NODEMAILER_SERVICE_PASSWORD);a=process.env.APP_NODEMAILER_SERVICE||"Nodemailer Service";break;case"nodemailer-sendgrid":t=!!process.env.APP_SENDGRID_API_KEY;a="SendGrid";break;default:t=!!e;a=e||"Unknown"}return{name:"Email Service",status:t?"up":"unconfigured",message:t?`${a} configured`:"Email not configured",critical:!1}}catch(e){return{name:"Email Service",status:"warning",message:`Check failed: ${(null==e?void 0:e.message)||"Unknown error"}`,critical:!1}}}async function checkExchangeProviders(){var e;try{const t=await(null===(e=db_1.models.exchange)||void 0===e?void 0:e.findOne({where:{status:!0}}));if(!t)return{name:"Exchange Provider",status:"unconfigured",message:"No exchange provider configured",critical:!1};const a=t.name,s=process.env[`APP_${a.toUpperCase()}_API_KEY`],n=process.env[`APP_${a.toUpperCase()}_API_SECRET`];return s&&n?{name:"Exchange Provider",status:"up",message:`${a} configured`,critical:!1}:{name:"Exchange Provider",status:"warning",message:`${a} enabled but API credentials missing`,critical:!1}}catch(e){return{name:"Exchange Provider",status:"warning",message:"Could not verify exchange provider",critical:!1}}}async function checkPendingTransactions(){try{if(!db_1.models.transaction)return{name:"Transaction Queue",status:"up",message:"Transaction system ready",critical:!1};const e=await db_1.models.transaction.count({where:{status:"PENDING"}}),t=await db_1.models.transaction.count({where:{status:"PENDING",createdAt:{[sequelize_1.Op.lt]:new Date(Date.now()-2592e5)}}});return t>0?{name:"Transaction Queue",status:"warning",message:`${t} stuck transactions (>72h)`,critical:!1}:e>500?{name:"Transaction Queue",status:"warning",message:`High queue: ${e} pending`,critical:!1}:{name:"Transaction Queue",status:"up",message:e>0?`${e} pending`:"No pending",critical:!1}}catch(e){return{name:"Transaction Queue",status:"up",message:"Transaction system ready",critical:!1}}}async function checkPendingWithdrawals(){try{if(!db_1.models.transaction)return{name:"Withdrawal Queue",status:"up",message:"Withdrawal system ready",critical:!1};const e=await db_1.models.transaction.count({where:{type:"WITHDRAW",status:"PENDING"}}),t=await db_1.models.transaction.count({where:{type:"WITHDRAW",status:"PENDING",createdAt:{[sequelize_1.Op.lt]:new Date(Date.now()-6048e5)}}});return t>0?{name:"Withdrawal Queue",status:"warning",message:`${t} withdrawals pending >7 days`,critical:!1}:{name:"Withdrawal Queue",status:"up",message:e>0?`${e} pending`:"No pending",critical:!1}}catch(e){return{name:"Withdrawal Queue",status:"up",message:"Withdrawal system ready",critical:!1}}}async function checkKYCBacklog(){try{if(!db_1.models.kyc)return{name:"KYC Queue",status:"up",message:"KYC system ready",critical:!1};const e=await db_1.models.kyc.count({where:{status:"PENDING"}}),t=await db_1.models.kyc.count({where:{status:"PENDING",createdAt:{[sequelize_1.Op.lt]:new Date(Date.now()-6048e5)}}});return t>0?{name:"KYC Queue",status:"warning",message:`${t} KYC applications pending >7 days`,critical:!1}:e>50?{name:"KYC Queue",status:"warning",message:`High backlog: ${e} pending KYC`,critical:!1}:{name:"KYC Queue",status:"up",message:`${e} pending KYC applications`,critical:!1}}catch(e){return{name:"KYC Queue",status:"warning",message:"Could not check KYC queue",critical:!1}}}async function checkSupportTickets(){try{if(!db_1.models.supportTicket)return{name:"Support Queue",status:"up",message:"No open tickets",critical:!1};const e=await db_1.models.supportTicket.count({where:{status:"OPEN"}}),t=await db_1.models.supportTicket.count({where:{status:"OPEN",importance:"HIGH"}});return t>0?{name:"Support Queue",status:"warning",message:`${t} high priority tickets open`,critical:!1}:{name:"Support Queue",status:"up",message:`${e} open tickets`,critical:!1}}catch(e){return{name:"Support Queue",status:"up",message:"Support system ready",critical:!1}}}async function checkErrorRate(){try{if(!db_1.models.transaction)return{name:"Error Rate",status:"up",message:"No errors detected",critical:!1};const e=new Date(Date.now()-864e5),[t,a]=await Promise.all([db_1.models.transaction.count({where:{createdAt:{[sequelize_1.Op.gte]:e}}}),db_1.models.transaction.count({where:{status:"FAILED",createdAt:{[sequelize_1.Op.gte]:e}}})]);if(0===t)return{name:"Error Rate",status:"up",message:"No transactions in last 24h",critical:!1};const s=a/t*100;return s>10?{name:"Error Rate",status:"warning",message:`High error rate: ${s.toFixed(1)}% (${a}/${t})`,critical:!0}:s>5?{name:"Error Rate",status:"warning",message:`Elevated error rate: ${s.toFixed(1)}%`,critical:!1}:{name:"Error Rate",status:"up",message:`${s.toFixed(1)}% error rate (24h)`,critical:!1}}catch(e){return{name:"Error Rate",status:"warning",message:"Could not calculate error rate",critical:!1}}}async function checkWalletService(){try{const e=cache_1.CacheManager.getInstance(),t=await e.getExtensions();if(!t.has("ecosystem")&&!t.has("wallet_connect"))return null;const a=["ETH","BSC","POLYGON","FTM","ARBITRUM","OPTIMISM"];let s=!1,n="";for(const e of a){const t=process.env[`${e}_MAINNET_RPC`]||process.env[`${e}_TESTNET_RPC`];if(t){s=!0;try{const a=new ethers_1.ethers.JsonRpcProvider(t);await a.getBlockNumber();n=e;break}catch(e){}}}return s?n?{name:"Blockchain RPC",status:"up",message:`${n} connected`,critical:!1}:{name:"Blockchain RPC",status:"warning",message:"RPC configured but connection failed",critical:!1}:{name:"Blockchain RPC",status:"unconfigured",message:"No blockchain RPC configured",critical:!1}}catch(e){return{name:"Blockchain RPC",status:"warning",message:"Could not verify blockchain connectivity",critical:!1}}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const cache_1=require("@b/utils/cache"),redis_1=require("@b/utils/redis"),date_fns_1=require("date-fns"),ethers_1=require("ethers"),db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Gets batch system health status",operationId:"getBatchSystemHealth",tags:["Admin","System","Health"],responses:{200:{description:"System health status fetched successfully",content:{"application/json":{schema:{type:"object",properties:{overall:{type:"object",properties:{score:{type:"number"},status:{type:"string"}}},services:{type:"array",items:{type:"object",properties:{name:{type:"string"},status:{type:"string"},message:{type:"string"},latency:{type:"number"}}}}}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal system error"}},requiresAuth:!0,permission:"access.admin",logModule:"ADMIN_SYSTEM",logTitle:"Get Batch System Health"};exports.default=async e=>{var t,a;const{ctx:s}=e;try{null===(t=null==s?void 0:s.step)||void 0===t||t.call(s,"Running batch health checks");const e=[checkDatabase(),checkCache(),checkEmail(),checkExchangeProviders(),checkPendingTransactions(),checkPendingWithdrawals(),checkKYCBacklog(),checkSupportTickets(),checkErrorRate(),checkWalletService()],n=(await Promise.all(e)).filter(e=>null!==e);let r,c=100,i=!1;for(const e of n)if("down"===e.status)if(e.critical){i=!0;c-=40}else c-=15;else"warning"===e.status&&(e.critical?c-=15:c-=5);c=Math.max(0,c);r=i||c<50?"critical":c<80?"warning":"healthy";null===(a=null==s?void 0:s.success)||void 0===a||a.call(s,"Batch health checks completed");return{overall:{score:c,status:r},services:n,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){return{overall:{score:50,status:"warning"},services:[{name:"Health Check",status:"warning",message:`Health check error: ${(null==e?void 0:e.message)||"Unknown error"}`,critical:!1}],timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}};