"use strict";async function checkLicenseFileExists(e){if(!e)return!1;const t=process.cwd(),s=t.endsWith("backend")||t.endsWith("backend/")||t.endsWith("backend\\")?path_1.default.dirname(t):t,i=path_1.default.join(s,"lic",`${e}.lic`);try{await fs_1.promises.access(i);return!0}catch(e){return!1}}function hasNewerVersion(e,t){if(!e||!t)return!1;const s=e.split(".").map(Number),i=t.split(".").map(Number);for(let e=0;e<Math.max(s.length,i.length);e++){const t=s[e]||0,l=i[e]||0;if(l>t)return!0;if(t>l)return!1}return!1}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),db_1=require("@b/db"),sequelize_1=require("sequelize"),utils_1=require("@b/api/admin/system/utils"),console_1=require("@b/utils/console"),path_1=__importDefault(require("path")),fs_1=require("fs");exports.metadata={summary:"Lists all products (extensions, blockchains, exchange providers) with license status",operationId:"listAllProducts",tags:["Admin","System","Products"],responses:{200:{description:"List of all products with license and update information",content:{"application/json":{schema:{type:"object",properties:{extensions:{type:"array",items:{type:"object"}},blockchains:{type:"array",items:{type:"object"}},exchangeProviders:{type:"array",items:{type:"object"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Products"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.extension",logModule:"ADMIN_SYSTEM",logTitle:"Get All Products"};exports.default=async e=>{const{ctx:t}=e;let s={status:!1,products:[]};try{null==t||t.step("Fetching license updates");s=await(0,utils_1.fetchAllProductsUpdates)()}catch(e){console_1.logger.error("PRODUCTS","Failed to fetch license updates",e)}null==t||t.step("Fetching all products");const[i,l,n]=await Promise.all([db_1.models.extension.findAll({where:{[sequelize_1.Op.not]:{name:"swap"}},attributes:{exclude:["createdAt","updatedAt"]}}),db_1.models.ecosystemBlockchain?db_1.models.ecosystemBlockchain.findAll({attributes:{exclude:["createdAt","updatedAt"]}}):Promise.resolve([]),db_1.models.exchange.findAll({attributes:{exclude:["createdAt","updatedAt"]}})]);null==t||t.step("Processing extension licenses");const r=await Promise.all(i.map(async e=>{var t;const i=e.toJSON(),l=null===(t=s.products)||void 0===t?void 0:t.find(t=>t.product_id===e.productId);return{...i,category:"extension",licenseVerified:await checkLicenseFileExists(e.productId),hasLicenseUpdate:!!(null==l?void 0:l.has_version)&&hasNewerVersion(e.version,l.latest_version),licenseVersion:(null==l?void 0:l.latest_version)||null,licenseReleaseDate:(null==l?void 0:l.release_date)||null,licenseSummary:(null==l?void 0:l.summary)||null}}));null==t||t.step("Processing blockchain licenses");const o=await Promise.all(l.map(async e=>{var t;const i=e.toJSON(),l=null===(t=s.products)||void 0===t?void 0:t.find(t=>t.product_id===e.productId);return{...i,category:"blockchain",title:i.name||i.chain,licenseVerified:await checkLicenseFileExists(e.productId),hasLicenseUpdate:!!(null==l?void 0:l.has_version)&&hasNewerVersion(e.version||"0.0.1",l.latest_version),licenseVersion:(null==l?void 0:l.latest_version)||null,licenseReleaseDate:(null==l?void 0:l.release_date)||null,licenseSummary:(null==l?void 0:l.summary)||null}}));null==t||t.step("Processing exchange provider licenses");const a=await Promise.all(n.map(async e=>{var t;const i=e.toJSON(),l=null===(t=s.products)||void 0===t?void 0:t.find(t=>t.product_id===e.productId);return{...i,category:"exchange",licenseVerified:!!e.productId&&await checkLicenseFileExists(e.productId),hasLicenseUpdate:!!(null==l?void 0:l.has_version)&&hasNewerVersion(e.version||"0.0.1",l.latest_version),licenseVersion:(null==l?void 0:l.latest_version)||null,licenseReleaseDate:(null==l?void 0:l.release_date)||null,licenseSummary:(null==l?void 0:l.summary)||null}}));null==t||t.success("All products retrieved successfully");return{extensions:r.sort((e,t)=>e.title.localeCompare(t.title)),blockchains:o.sort((e,t)=>(e.title||e.chain||"").localeCompare(t.title||t.chain||"")),exchangeProviders:a.sort((e,t)=>e.title.localeCompare(t.title))}};