"use strict";async function ensureDirExists(e){try{await promises_1.default.access(e);console_1.logger.debug("LOGO",`Directory exists: ${e}`)}catch(t){if("ENOENT"!==t.code){console_1.logger.error("LOGO",`Directory access error: ${e}`,t);throw t}try{console_1.logger.debug("LOGO",`Creating directory: ${e}`);await promises_1.default.mkdir(e,{recursive:!0});console_1.logger.debug("LOGO",`Directory created successfully: ${e}`)}catch(t){console_1.logger.error("LOGO",`Failed to create directory: ${e}`,t);throw(0,error_1.createError)({statusCode:500,message:`Failed to create logo directory: ${t.message}`})}}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const promises_1=__importDefault(require("fs/promises")),fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),sharp_1=__importDefault(require("sharp")),query_1=require("@b/utils/query"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),isProduction="production"===process.env.NODE_ENV;let BASE_UPLOAD_DIR;if(isProduction){const e=[path_1.default.join(process.cwd(),"frontend","public","img","logo"),path_1.default.join(process.cwd(),"public","img","logo"),path_1.default.join(process.cwd(),"..","frontend","public","img","logo"),path_1.default.join(process.cwd(),"..","public","img","logo")];BASE_UPLOAD_DIR=e[0];for(const t of e){const e=path_1.default.dirname(t);if(fs_1.default.existsSync(e)){BASE_UPLOAD_DIR=t;break}}console_1.logger.debug("LOGO","Production mode detected");console_1.logger.debug("LOGO",`Current working directory: ${process.cwd()}`);console_1.logger.debug("LOGO",`Selected logo directory: ${BASE_UPLOAD_DIR}`);console_1.logger.debug("LOGO",`Logo directory exists: ${fs_1.default.existsSync(BASE_UPLOAD_DIR)}`);console_1.logger.debug("LOGO",`Parent directory exists: ${fs_1.default.existsSync(path_1.default.dirname(BASE_UPLOAD_DIR))}`)}else BASE_UPLOAD_DIR=path_1.default.join(process.cwd(),"..","frontend","public","img","logo");const LOGO_CONFIGS={logo:{width:512,height:512,formats:["png","webp"]},"logo-text":{width:300,height:100,formats:["png","webp"]},"favicon-16x16":{width:16,height:16,formats:["png","webp"]},"favicon-32x32":{width:32,height:32,formats:["png","webp"]},"favicon-96x96":{width:96,height:96,formats:["png","webp"]},"apple-icon-57x57":{width:57,height:57,formats:["png","webp"]},"apple-icon-60x60":{width:60,height:60,formats:["png","webp"]},"apple-icon-72x72":{width:72,height:72,formats:["png","webp"]},"apple-icon-76x76":{width:76,height:76,formats:["png","webp"]},"apple-icon-114x114":{width:114,height:114,formats:["png","webp"]},"apple-icon-120x120":{width:120,height:120,formats:["png","webp"]},"apple-icon-144x144":{width:144,height:144,formats:["png","webp"]},"apple-icon-152x152":{width:152,height:152,formats:["png","webp"]},"apple-icon-180x180":{width:180,height:180,formats:["png","webp"]},"apple-icon-precomposed":{width:192,height:192,formats:["png","webp"]},"apple-icon":{width:192,height:192,formats:["png","webp"]},"apple-touch-icon":{width:180,height:180,formats:["png","webp"]},"android-icon-36x36":{width:36,height:36,formats:["png","webp"]},"android-icon-48x48":{width:48,height:48,formats:["png","webp"]},"android-icon-72x72":{width:72,height:72,formats:["png","webp"]},"android-icon-96x96":{width:96,height:96,formats:["png","webp"]},"android-icon-144x144":{width:144,height:144,formats:["png","webp"]},"android-icon-192x192":{width:192,height:192,formats:["png","webp"]},"android-icon-256x256":{width:256,height:256,formats:["png","webp"]},"android-icon-384x384":{width:384,height:384,formats:["png","webp"]},"android-icon-512x512":{width:512,height:512,formats:["png","webp"]},"android-chrome-192x192":{width:192,height:192,formats:["png","webp"]},"android-chrome-256x256":{width:256,height:256,formats:["png","webp"]},"android-chrome-384x384":{width:384,height:384,formats:["png","webp"]},"android-chrome-512x512":{width:512,height:512,formats:["png","webp"]},"ms-icon-70x70":{width:70,height:70,formats:["png","webp"]},"ms-icon-144x144":{width:144,height:144,formats:["png","webp"]},"ms-icon-150x150":{width:150,height:150,formats:["png","webp"]},"ms-icon-310x310":{width:310,height:310,formats:["png","webp"]},"mstile-70x70":{width:70,height:70,formats:["png","webp"]},"mstile-144x144":{width:144,height:144,formats:["png","webp"]},"mstile-150x150":{width:150,height:150,formats:["png","webp"]},"mstile-310x150":{width:310,height:150,formats:["webp"]},"mstile-310x310":{width:310,height:310,formats:["png","webp"]}};exports.metadata={summary:"Upload and update logo files",description:"Uploads a new logo and updates all logo variants in the /img/logo directory with the same filenames",operationId:"uploadLogo",tags:["Admin","Logo"],logModule:"ADMIN_SYS",logTitle:"Upload logo",requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{file:{type:"string",description:"Base64 encoded logo file data"},logoType:{type:"string",enum:["logo","logo-text"],description:"Type of logo to update (main logo or logo with text)",default:"logo"}},required:["file"]}}}},responses:{200:{description:"Logo uploaded and updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},updatedFiles:{type:"array",items:{type:"string"},description:"List of updated logo files"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Logo"),500:query_1.serverErrorResponse},permission:"access.system"};exports.default=async e=>{var t;const{body:o,user:i,ctx:r}=e;if(!i)throw(0,error_1.createError)({statusCode:401,message:"User not found"});const{file:s,logoType:a="logo"}=o;null==r||r.step("Validating logo upload request");if(!s)throw(0,error_1.createError)({statusCode:400,message:"No file provided"});if("string"!=typeof s||!s.startsWith("data:image/"))throw(0,error_1.createError)({statusCode:400,message:"Invalid image file format"});const n=s.split(",")[1];if(!n)throw(0,error_1.createError)({statusCode:400,message:"Invalid file data"});if(3*n.length/4>5242880)throw(0,error_1.createError)({statusCode:400,message:"File size exceeds maximum limit of 5MB"});const p=(null===(t=s.match(/^data:(.*);base64,/))||void 0===t?void 0:t[1])||"";if(!["image/jpeg","image/jpg","image/png","image/webp","image/svg+xml"].includes(p))throw(0,error_1.createError)({statusCode:400,message:"Only image files are allowed for logos"});const d=Buffer.from(n,"base64"),g=[];try{null==r||r.step("Processing logo upload");await ensureDirExists(BASE_UPLOAD_DIR);null==r||r.step(`Generating ${a} variants`);if("logo-text"===a){const e=LOGO_CONFIGS["logo-text"];for(const t of e.formats){const o=`logo-text.${t}`,i=path_1.default.join(BASE_UPLOAD_DIR,o);let r;r="webp"===t?await(0,sharp_1.default)(d).resize(e.width,e.height,{fit:"contain",background:{r:0,g:0,b:0,alpha:0}}).webp({quality:90}).toBuffer():await(0,sharp_1.default)(d).resize(e.width,e.height,{fit:"contain",background:{r:0,g:0,b:0,alpha:0}}).png({quality:90}).toBuffer();await promises_1.default.writeFile(i,r);g.push(o)}}else for(const[e,t]of Object.entries(LOGO_CONFIGS))if("logo-text"!==e)for(const o of t.formats){const i=`${e}.${o}`,r=path_1.default.join(BASE_UPLOAD_DIR,i);let s;s="webp"===o?await(0,sharp_1.default)(d).resize(t.width,t.height,{fit:"contain",background:{r:0,g:0,b:0,alpha:0}}).webp({quality:90}).toBuffer():await(0,sharp_1.default)(d).resize(t.width,t.height,{fit:"contain",background:{r:0,g:0,b:0,alpha:0}}).png({quality:90}).toBuffer();await promises_1.default.writeFile(r,s);g.push(i)}null==r||r.success(`Logo updated successfully: ${g.length} files (${a})`);return{message:`Logo updated successfully. ${g.length} files updated.`,updatedFiles:g}}catch(e){console_1.logger.error("LOGO","Error updating logo files",e);null==r||r.fail("Failed to update logo files");throw(0,error_1.createError)({statusCode:500,message:"Failed to update logo files"})}};