"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),redis_1=require("@b/utils/redis"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),redis=redis_1.RedisSingleton.getInstance(),cacheDirPath=path_1.default.resolve(process.cwd(),"data","chart");exports.metadata={summary:"Clean chart data for specified markets and intervals",operationId:"cleanChartData",tags:["Admin","Exchange","Chart"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{symbols:{type:"array",items:{type:"string"},description:"Array of market symbols to clean (e.g., ['BTC/USDT', 'ETH/USDT'])"},intervals:{type:"array",items:{type:"string"},description:"Array of intervals to clean (e.g., ['1m', '5m', '1h']). If empty, cleans all intervals."},cleanRedis:{type:"boolean",description:"Also clean Redis cache",default:!0},cleanFiles:{type:"boolean",description:"Also clean file cache",default:!0}},required:["symbols"]}}}},responses:{200:{description:"Chart data cleaned successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},cleaned:{type:"object",properties:{redis:{type:"number"},files:{type:"number"}}},errors:{type:"array",items:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"manage.exchange.chart"};const ALL_INTERVALS=["1m","3m","5m","15m","30m","1h","2h","4h","6h","8h","12h","1d","3d","1w"];exports.default=async e=>{const{body:t}=e,{symbols:r,intervals:s,cleanRedis:a=!0,cleanFiles:i=!0}=t;if(!r||!Array.isArray(r)||0===r.length)throw(0,error_1.createError)({statusCode:400,message:"symbols array is required"});const o=s&&s.length>0?s:ALL_INTERVALS,n=[];let l=0,c=0;for(const e of r){const[t,r]=e.split("/"),s=path_1.default.join(cacheDirPath,t,r);for(const t of o){if(a)try{const r=`ohlcv:${e}:${t}`;await redis.del(r);l++}catch(r){n.push(`Redis clean failed for ${e}:${t}: ${r.message}`)}if(i){const r=path_1.default.join(s,`${t}.json.gz`);if(fs_1.default.existsSync(r))try{fs_1.default.unlinkSync(r);c++}catch(r){n.push(`File clean failed for ${e}:${t}: ${r.message}`)}}}if(i&&fs_1.default.existsSync(s))try{0===fs_1.default.readdirSync(s).length&&fs_1.default.rmdirSync(s)}catch(e){}}const d={cleaned:{redis:l,files:c}};n.length>0&&(d.errors=n);return d};