"use strict";function getIntervalMs(e){return{"1m":6e4,"3m":18e4,"5m":3e5,"15m":9e5,"30m":18e5,"1h":36e5,"2h":72e5,"4h":144e5,"6h":216e5,"8h":288e5,"12h":432e5,"1d":864e5,"3d":2592e5,"1w":6048e5}[e]||6e4}function compress(e){return zlib_1.default.gzipSync(JSON.stringify(e))}function decompress(e){return JSON.parse(zlib_1.default.gunzipSync(e).toString())}function getCacheFilePath(e,t){const[r,s]=e.split("/"),a=path_1.default.join(cacheDirPath,r,s);fs_1.default.existsSync(a)||fs_1.default.mkdirSync(a,{recursive:!0});return path_1.default.join(a,`${t}.json.gz`)}function broadcastProgress(e,t){try{Websocket_1.messageBroker.broadcastToSubscribedClients("/api/admin/finance/exchange/chart/build",{jobId:e},{type:"progress",jobId:e,data:t})}catch(e){}}async function buildChartDataAsync(e,t,r,s,a){var o,i;const n=[];let l=0;console_1.logger.info("Chart Build",`Job ${e} - Starting async build process`);try{console_1.logger.info("Chart Build",`Job ${e} - Initializing exchange...`);const c=await exchange_1.default.startExchange();if(!c){console_1.logger.error("Chart Build",`Job ${e} - Exchange not available`);throw(0,error_1.createError)({statusCode:503,message:"Exchange not available"})}console_1.logger.info("Chart Build",`Job ${e} - Exchange initialized: ${c.name||c.id||"unknown"}`);const d=Date.now(),u=t.length*r.length;let h=0;console_1.logger.info("Chart Build",`Job ${e} - Total tasks: ${u} (${t.length} markets x ${r.length} intervals)`);for(const g of t){const t=`${g.currency}/${g.pair}`;console_1.logger.info("Chart Build",`Job ${e} - Processing market: ${t}`);for(const l of r){try{const r=getIntervalMs(l),n=d-24*s*60*60*1e3;let g=[];const m=getCacheFilePath(t,l);if(fs_1.default.existsSync(m))try{g=decompress(fs_1.default.readFileSync(m))}catch(e){}const f=500;let b=n;const p=[...g];if(g.length>0){const e=g[g.length-1][0];e>n&&(b=e+r)}let _=0;for(;b<d;)try{_++;const e=await c.fetchOHLCV(t,l,b,f);if(!e||0===e.length)break;p.push(...e);b=e[e.length-1][0]+r;await new Promise(e=>setTimeout(e,a))}catch(r){if(!(null===(o=r.message)||void 0===o?void 0:o.includes("rate"))&&!(null===(i=r.message)||void 0===i?void 0:i.includes("limit")))throw r;console_1.logger.warn("Chart Build",`Job ${e} - Rate limited for ${t}:${l}, waiting...`);await new Promise(e=>setTimeout(e,5*a))}const y=new Map;for(const e of p)y.set(e[0],e);const $=Array.from(y.values()).sort((e,t)=>e[0]-t[0]),w=compress($);fs_1.default.writeFileSync(m,w);const v=`ohlcv:${t}:${l}`;await redis.set(v,JSON.stringify($),"EX",86400);h++;console_1.logger.info("Chart Build",`Job ${e} - Completed ${t}:${l} (${h}/${u})`)}catch(r){console_1.logger.error("Chart Build",`Job ${e} - Error for ${t}:${l}: ${r.message}`);n.push(`${t}:${l} - ${r.message}`)}const r={status:"running",progress:Math.round(h/u*100),completedTasks:h,totalTasks:u,errors:n,currentSymbol:t,currentInterval:l};await redis.set(`chart_build_job:${e}`,JSON.stringify(r),"EX",3600);broadcastProgress(e,r)}l++}console_1.logger.info("Chart Build",`Job ${e} - Build completed successfully`);const g={status:"completed",progress:100,completedMarkets:l,totalMarkets:t.length,errors:n,completedAt:Date.now()};await redis.set(`chart_build_job:${e}`,JSON.stringify(g),"EX",3600);broadcastProgress(e,g)}catch(t){console_1.logger.error("Chart Build",`Job ${e} - Build failed: ${t.message}`);const r={status:"failed",error:t.message,errors:n,failedAt:Date.now()};await redis.set(`chart_build_job:${e}`,JSON.stringify(r),"EX",3600);broadcastProgress(e,r)}finally{activeBuilds.delete(e)}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),zlib_1=__importDefault(require("zlib")),db_1=require("@b/db"),redis_1=require("@b/utils/redis"),exchange_1=__importDefault(require("@b/utils/exchange")),query_1=require("@b/utils/query"),console_1=require("@b/utils/console"),Websocket_1=require("@b/handler/Websocket"),error_1=require("@b/utils/error"),redis=redis_1.RedisSingleton.getInstance(),cacheDirPath=path_1.default.resolve(process.cwd(),"data","chart");exports.metadata={summary:"Build/rebuild chart data for specified markets",operationId:"buildChartData",tags:["Admin","Exchange","Chart"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{symbols:{type:"array",items:{type:"string"},description:"Array of market symbols to build (e.g., ['BTC/USDT']). If empty, builds all enabled markets."},intervals:{type:"array",items:{type:"string"},description:"Array of intervals to build (e.g., ['1h', '4h', '1d']). If empty, builds common intervals."},days:{type:"number",description:"Number of days of historical data to fetch",default:30},rateLimit:{type:"number",description:"Delay in milliseconds between API requests",default:500}}}}}},responses:{200:{description:"Chart data build started",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},jobId:{type:"string"},markets:{type:"number"},intervals:{type:"number"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"manage.exchange.chart"};const DEFAULT_INTERVALS=["1m","3m","5m","15m","30m","1h","2h","4h","6h","8h","12h","1d","3d"],activeBuilds=new Map;exports.default=async e=>{const{body:t}=e,{symbols:r,intervals:s,days:a=30,rateLimit:o=500}=t;let i=[];if(r&&r.length>0)i=r.map(e=>{const[t,r]=e.split("/");return{currency:t,pair:r}});else{i=await db_1.models.exchangeMarket.findAll({where:{status:!0},attributes:["currency","pair"],raw:!0})}const n=s&&s.length>0?s:DEFAULT_INTERVALS,l=`build_${Date.now()}`;activeBuilds.set(l,{status:"running",progress:0,errors:[]});await redis.set(`chart_build_job:${l}`,JSON.stringify({status:"running",startTime:Date.now(),totalMarkets:i.length,totalIntervals:n.length,completedMarkets:0,errors:[]}),"EX",3600);console_1.logger.info("Chart Build",`Starting job ${l} for ${i.length} markets, ${n.length} intervals`);buildChartDataAsync(l,i,n,a,o).catch(e=>{console_1.logger.error("Chart Build",`Job ${l} failed with error: ${e.message}`)});return{message:"Chart data build started in background",jobId:l,markets:i.length,intervals:n.length,estimatedTime:`${Math.ceil(i.length*n.length*o/6e4)} minutes`}};