"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves a single currency by its ID",description:"This endpoint retrieves a single currency by its ID.",operationId:"getCurrencyById",tags:["Finance","Currency"],requiresAuth:!0,parameters:[{index:0,name:"type",in:"query",required:!0,schema:{type:"string",enum:["FIAT","SPOT","ECO"]}}],responses:{200:{description:"Currency retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{value:{type:"string"},label:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse},logModule:"ADMIN_FIN",logTitle:"Get Currency Options"};exports.default=async e=>{const{user:r,query:t,ctx:n}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");const{type:s}=t,c={status:!0};try{null==n||n.step("Fetching currency options");let e,r;switch(s){case"FIAT":e=await db_1.models.currency.findAll({where:c});r=e.map(e=>({id:e.id,name:`${e.id} > ${e.name}`}));break;case"SPOT":e=await db_1.models.exchangeCurrency.findAll({where:c});r=e.map(e=>({id:e.currency,name:`${e.currency} > ${e.name}`}));break;case"ECO":e=await db_1.models.ecosystemToken.findAll({where:c});r=e.filter((e,r,t)=>t.findIndex(r=>r.currency===e.currency)===r).map(e=>({id:e.currency,name:`${e.currency} > ${e.name}`}));break;default:r=[]}null==n||n.success("Currency options retrieved successfully");return r}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching currencies")}};