"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils"),binary_settings_cache_1=require("@b/utils/binary-settings-cache"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Update Binary Settings",operationId:"updateBinarySettings",tags:["Admin","Binary","Settings"],description:"Updates the binary trading settings configuration. Validates settings before saving and returns warnings for potentially risky configurations.",requestBody:{description:"Binary settings configuration to save",content:{"application/json":{schema:{type:"object",description:"Partial or complete binary settings object"}}},required:!0},responses:{200:{description:"Binary settings updated successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},settings:{type:"object",description:"The saved binary trading settings"},validation:{type:"object",properties:{valid:{type:"boolean"},errors:{type:"array",items:{type:"string"}},warnings:{type:"array",items:{type:"object"}}}}}}}}},400:{description:"Validation failed - settings contain errors",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},errors:{type:"array",items:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"edit.binary.settings"};exports.default=async e=>{var t,s,i,r,a,n;const{user:o,body:l,ctx:u}=e;if(!(null==o?void 0:o.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!l||"object"!=typeof l)throw(0,error_1.createError)({statusCode:400,message:"Invalid request body"});null==u||u.step("Processing binary settings update");try{const e=null===(i=null!==(t=l.binaryStatus)&&void 0!==t?t:null===(s=l.global)||void 0===s?void 0:s.enabled)||void 0===i||i,o=null===(n=null!==(r=l.binaryPracticeStatus)&&void 0!==r?r:null===(a=l.global)||void 0===a?void 0:a.practiceEnabled)||void 0===n||n;null==u||u.step("Merging with default settings");const c=(0,utils_1.mergeWithDefaults)(l.binarySettings||l);c._lastModified=(new Date).toISOString();null==u||u.step("Validating settings configuration");const d=(0,utils_1.validateBinarySettings)(c);if(!d.valid){null==u||u.fail("Settings validation failed");throw(0,error_1.createError)({statusCode:400,message:`Validation failed: ${d.errors.join(", ")}`})}null==u||u.step("Saving settings to database");const g=JSON.stringify(c);await Promise.all([db_1.models.settings.upsert({key:"binaryStatus",value:e?"true":"false"}),db_1.models.settings.upsert({key:"binaryPracticeStatus",value:o?"true":"false"}),db_1.models.settings.upsert({key:"binarySettings",value:g})]);null==u||u.step("Clearing settings cache");(0,binary_settings_cache_1.invalidateBinarySettingsCache)();const p=cache_1.CacheManager.getInstance();await p.clearCache();null==u||u.success("Binary settings updated successfully");return{success:!0,message:"Binary settings updated successfully",settings:c,validation:d}}catch(e){if(e.statusCode)throw e;null==u||u.fail(e.message||"Failed to update binary settings");throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to update binary settings"})}};