"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),utils_1=require("./utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Binary Settings",operationId:"getBinarySettings",tags:["Admin","Binary","Settings"],description:"Retrieves the current binary trading settings configuration including order types, barrier levels, durations, and risk management settings.",responses:{200:{description:"Binary settings retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{settings:{type:"object",description:"The binary trading settings configuration"},validation:{type:"object",properties:{valid:{type:"boolean"},errors:{type:"array",items:{type:"string"}},warnings:{type:"array",items:{type:"object",properties:{level:{type:"string"},category:{type:"string"},message:{type:"string"},suggestion:{type:"string"},field:{type:"string"}}}}}},isDefault:{type:"boolean",description:"Whether these are default settings (not yet configured)"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"access.binary.settings"};exports.default=async e=>{const{user:t,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching binary settings from database");try{const[e,t,i]=await Promise.all([db_1.models.settings.findOne({where:{key:"binarySettings"}}),db_1.models.settings.findOne({where:{key:"binaryStatus"}}),db_1.models.settings.findOne({where:{key:"binaryPracticeStatus"}})]);let r,n=!1;if(null==e?void 0:e.value){null==s||s.step("Parsing stored settings");try{const t=JSON.parse(e.value);r=(0,utils_1.mergeWithDefaults)(t)}catch(e){console.error("Failed to parse binary settings:",e);r=utils_1.DEFAULT_BINARY_SETTINGS;n=!0}}else{null==s||s.step("Using default settings");r=utils_1.DEFAULT_BINARY_SETTINGS;n=!0}const a="false"!==(null==t?void 0:t.value)&&("true"===(null==t?void 0:t.value)||!t),o="false"!==(null==i?void 0:i.value)&&("true"===(null==i?void 0:i.value)||!i);null==s||s.step("Validating settings configuration");const l=(0,utils_1.validateBinarySettings)(r);null==s||s.success("Binary settings retrieved successfully");return{settings:r,binaryStatus:a,binaryPracticeStatus:o,validation:l,isDefault:n}}catch(e){null==s||s.fail(e.message||"Failed to fetch binary settings");throw e}};