"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query");exports.metadata={summary:"Get Available Markets for Binary Trading",operationId:"getAvailableMarketsForBinary",tags:["Admin","Binary","Markets"],description:"Returns available markets from exchange and ecosystem that can be added as binary markets.",parameters:[{name:"source",in:"query",description:"Market source: 'exchange' or 'ecosystem'",schema:{type:"string",enum:["exchange","ecosystem"]}}],requiresAuth:!0,responses:{200:{description:"Available markets retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{exchangeMarkets:{type:"array",items:{type:"object",properties:{id:{type:"string"},currency:{type:"string"},pair:{type:"string"},symbol:{type:"string"},hasAiMarketMaker:{type:"boolean"},hasBinaryAiEngine:{type:"boolean"}}}},ecosystemMarkets:{type:"array",items:{type:"object",properties:{id:{type:"string"},currency:{type:"string"},pair:{type:"string"},symbol:{type:"string"},hasAiMarketMaker:{type:"boolean"},hasBinaryAiEngine:{type:"boolean"},aiMarketMakerId:{type:"string",nullable:!0}}}},existingBinaryMarkets:{type:"array",items:{type:"object",properties:{currency:{type:"string"},pair:{type:"string"}}}},binarySettings:{type:"object",properties:{isRiseFallOnly:{type:"boolean"},orderTypes:{type:"object"}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},permission:"view.binary.market"};exports.default=async e=>{var r,a,t,i,s,n,d,l,o,y,u,p;const{query:c}=e,m=null==c?void 0:c.source,b=await db_1.models.binaryMarket.findAll({attributes:["currency","pair"]}),k=new Set(b.map(e=>`${e.currency}/${e.pair}`));let v=[];if(db_1.models.aiMarketMaker){v=(await db_1.models.aiMarketMaker.findAll({attributes:["id","marketId","status"]})).map(e=>({id:e.id,marketId:e.marketId,status:e.status}))}let M=[];if(db_1.models.binaryAiEngine){M=(await db_1.models.binaryAiEngine.findAll({attributes:["id","marketMakerId","status","allowedOrderTypes"]})).map(e=>({id:e.id,marketMakerId:e.marketMakerId,status:e.status,allowedOrderTypes:e.allowedOrderTypes}))}const g=new Map(v.map(e=>[e.marketId,e])),h=new Map(M.map(e=>[e.marketMakerId,e]));let A=null;try{const e=await(null===(r=db_1.models.settings)||void 0===r?void 0:r.findOne({where:{key:"binarySettings"}}));(null==e?void 0:e.value)&&(A=JSON.parse(e.value))}catch(e){}const _=!(!0!==(null===(t=null===(a=null==A?void 0:A.orderTypes)||void 0===a?void 0:a.RISE_FALL)||void 0===t?void 0:t.enabled)||(null===(s=null===(i=null==A?void 0:A.orderTypes)||void 0===i?void 0:i.HIGHER_LOWER)||void 0===s?void 0:s.enabled)||(null===(d=null===(n=null==A?void 0:A.orderTypes)||void 0===n?void 0:n.TOUCH_NO_TOUCH)||void 0===d?void 0:d.enabled)||(null===(o=null===(l=null==A?void 0:A.orderTypes)||void 0===l?void 0:l.CALL_PUT)||void 0===o?void 0:o.enabled)||(null===(u=null===(y=null==A?void 0:A.orderTypes)||void 0===y?void 0:y.TURBO)||void 0===u?void 0:u.enabled)),f={exchangeMarkets:[],ecosystemMarkets:[],existingBinaryMarkets:b.map(e=>({currency:e.currency,pair:e.pair})),binarySettings:{isRiseFallOnly:_,orderTypes:(null==A?void 0:A.orderTypes)||{}}};if(!m||"exchange"===m){const e=await db_1.models.exchangeMarket.findAll({where:{status:!0},attributes:["id","currency","pair"],order:[["currency","ASC"],["pair","ASC"]]});f.exchangeMarkets=e.filter(e=>!k.has(`${e.currency}/${e.pair}`)).map(e=>({id:e.id,currency:e.currency,pair:e.pair,symbol:`${e.currency}/${e.pair}`,hasAiMarketMaker:!1,hasBinaryAiEngine:!1}))}if(!m||"ecosystem"===m){const e=await(null===(p=db_1.models.ecosystemMarket)||void 0===p?void 0:p.findAll({where:{status:!0},attributes:["id","currency","pair"],order:[["currency","ASC"],["pair","ASC"]]}))||[];f.ecosystemMarkets=e.filter(e=>!k.has(`${e.currency}/${e.pair}`)).map(e=>{const r=g.get(e.id),a=r?h.get(r.id):null;return{id:e.id,currency:e.currency,pair:e.pair,symbol:`${e.currency}/${e.pair}`,hasAiMarketMaker:!!r,hasBinaryAiEngine:!!a,aiMarketMakerId:(null==r?void 0:r.id)||null,aiMarketMakerStatus:(null==r?void 0:r.status)||null,binaryAiEngineStatus:(null==a?void 0:a.status)||null}})}return f};