"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.supportTicketUpdateSchema=exports.supportTicketSchema=exports.baseSupportTicketSchema=void 0;const schema_1=require("@b/utils/schema"),id={...(0,schema_1.baseStringSchema)("ID of the support ticket"),nullable:!0},userId=(0,schema_1.baseStringSchema)("ID of the user who created the ticket"),agentId=(0,schema_1.baseStringSchema)("ID of the agent assigned to the ticket"),subject=(0,schema_1.baseStringSchema)("Subject of the ticket"),importance=(0,schema_1.baseStringSchema)("Importance of the ticket"),status=(0,schema_1.baseEnumSchema)("Status of the ticket",["PENDING","OPEN","REPLIED","CLOSED"]),messages={type:"object",description:"Messages associated with the chat"},type=(0,schema_1.baseEnumSchema)("Type of the ticket",["LIVE","TICKET"]);exports.baseSupportTicketSchema={id:id,userId:userId,agentId:agentId,messages:messages,subject:subject,importance:importance,status:status,type:type};exports.supportTicketSchema={id:{type:"string",description:"Unique identifier for the support ticket"},userId:{type:"string",description:"ID of the user who created the ticket"},agentId:{type:"string",nullable:!0,description:"ID of the agent assigned to the ticket"},agentName:{type:"string",nullable:!0,description:"Name of the assigned agent"},subject:{type:"string",description:"Subject/title of the ticket"},importance:{type:"string",enum:["LOW","MEDIUM","HIGH"],description:"Priority level of the ticket"},status:{type:"string",enum:["PENDING","OPEN","REPLIED","CLOSED"],description:"Current status of the ticket"},messages:{type:"array",description:"Array of messages in the ticket conversation",items:{type:"object",properties:{type:{type:"string",enum:["client","agent"]},text:{type:"string"},time:{type:"string",format:"date-time"},userId:{type:"string"},attachment:{type:"string",nullable:!0}}}},type:{type:"string",enum:["LIVE","TICKET"],description:"Type of support interaction"},tags:{type:"array",description:"Tags associated with the ticket",items:{type:"string"}},responseTime:{type:"number",nullable:!0,description:"Response time in minutes"},satisfaction:{type:"number",nullable:!0,description:"User satisfaction rating (1-5)"},createdAt:{type:"string",format:"date-time",description:"Date and time when the ticket was created"},updatedAt:{type:"string",format:"date-time",description:"Date and time when the ticket was last updated"},deletedAt:{type:"string",format:"date-time",nullable:!0,description:"Date and time when the ticket was deleted (soft delete)"}};exports.supportTicketUpdateSchema={type:"object",properties:{subject:subject,importance:importance,status:status,type:type},required:["subject","importance","status"]};