"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Support Ticket Dashboard Analytics",description:"Returns admin analytics for support tickets (counts, averages, etc).",operationId:"adminSupportTicketStats",tags:["Admin","CRM","Support Ticket"],requiresAuth:!0,permission:"access.support.ticket",responses:{200:{description:"Support ticket analytics",content:{"application/json":{schema:{type:"object",properties:{total:{type:"number"},open:{type:"number"},pending:{type:"number"},closed:{type:"number"},unassigned:{type:"number"},avgResponseTime:{type:"number"},satisfaction:{type:"number"}}}}}},401:{description:"Unauthorized"},500:{description:"Server error"}},logModule:"ADMIN_CRM",logTitle:"Get Support Ticket Stats"};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching support ticket statistics");const[s,i,o,n,r,a,p]=await Promise.all([db_1.models.supportTicket.count(),db_1.models.supportTicket.count({where:{status:"OPEN"}}),db_1.models.supportTicket.count({where:{status:"PENDING"}}),db_1.models.supportTicket.count({where:{status:"CLOSED"}}),db_1.models.supportTicket.count({where:{agentId:null}}),db_1.models.supportTicket.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("responseTime")),"avgResponseTime"]],where:{responseTime:{[sequelize_1.Op.gt]:0}},raw:!0}),db_1.models.supportTicket.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("satisfaction")),"avgSatisfaction"]],where:{satisfaction:{[sequelize_1.Op.not]:null}},raw:!0})]);null==t||t.success("Support ticket statistics retrieved successfully");return{total:s,open:i,pending:o,closed:n,unassigned:r,avgResponseTime:(null==a?void 0:a.avgResponseTime)?Math.round(Number(a.avgResponseTime)):0,satisfaction:(null==p?void 0:p.avgSatisfaction)?Number(p.avgSatisfaction).toFixed(2):0}};