"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");exports.metadata={summary:"Get All Verification Services",description:"Retrieves all available verification services for KYC processes.",operationId:"getVerificationServices",tags:["KYC","Verification Services"],logModule:"ADMIN_CRM",logTitle:"Get verification services",responses:{200:{description:"Verification services retrieved successfully.",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Unique identifier for the service"},name:{type:"string",description:"Name of the verification service"},description:{type:"string",description:"Description of the service"},type:{type:"string",description:"Type of verification service"},status:{type:"string",description:"Current status of the service"},integrationDetails:{type:"object",description:"Integration details for the service"},createdAt:{type:"string",format:"date-time",description:"When the service was created"},updatedAt:{type:"string",format:"date-time",description:"When the service was last updated"}}}}}}},500:{description:"Internal Server Error."}},permission:"view.kyc.verification",requiresAuth:!0};exports.default=async e=>{const{ctx:i}=e;try{null==i||i.step("Fetching verification services");const e=await db_1.models.kycVerificationService.findAll({order:[["createdAt","ASC"]]});null==i||i.success("Verification services retrieved successfully");return e}catch(e){console_1.logger.error("KYC","Error in getVerificationServices",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch verification services"})}};