"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk Update KYC Levels",description:"Updates multiple KYC levels by their IDs with a specified status.",operationId:"bulkUpdateKycLevelsStatus",tags:["KYC","Levels"],logModule:"ADMIN_CRM",logTitle:"Bulk update KYC level status",requestBody:{description:"Object containing an array of KYC level IDs and the new status",required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of KYC level IDs to update"},status:{type:"string",description:"The new status to set for the selected KYC levels"}},required:["ids","status"]}}}},responses:{200:{description:"KYC levels updated successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},count:{type:"number"}}}}}},400:{description:"Missing or invalid required fields."},404:{description:"No KYC levels found for the provided IDs."},500:{description:"Internal Server Error."}},permission:"edit.kyc.level",requiresAuth:!0};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:r,status:o}=t;if(!r||!Array.isArray(r)||0===r.length||"string"!=typeof o)throw(0,error_1.createError)({statusCode:400,message:"Missing or invalid ids or status"});null==s||s.step(`Bulk updating ${r.length} KYC levels to status: ${o}`);const[i]=await db_1.models.kycLevel.update({status:o,updatedAt:new Date},{where:{id:r}});if(0===i)throw(0,error_1.createError)({statusCode:404,message:"No KYC levels found for the provided IDs"});null==s||s.success(`${i} KYC levels updated to ${o}`);return{message:"KYC levels updated successfully.",count:i}};