"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk Delete KYC Levels",description:"Deletes multiple KYC levels by their IDs.",operationId:"bulkDeleteKycLevels",tags:["KYC","Levels"],logModule:"ADMIN_CRM",logTitle:"Bulk delete KYC levels",requestBody:{description:"Array of KYC level IDs to delete",required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of KYC level IDs to delete"}},required:["ids"]}}}},responses:{200:{description:"KYC levels deleted successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},count:{type:"number"}}}}}},400:{description:"Missing required fields."},404:{description:"No KYC levels found for the provided IDs."},500:{description:"Internal Server Error."}},permission:"delete.kyc.level",requiresAuth:!0};exports.default=async e=>{const{body:s,ctx:r}=e,{ids:t}=s;if(!t||!Array.isArray(t)||0===t.length)throw(0,error_1.createError)({statusCode:400,message:"Missing or invalid ids"});null==r||r.step(`Bulk deleting ${t.length} KYC levels`);const l=await db_1.models.kycLevel.destroy({where:{id:t}});if(0===l)throw(0,error_1.createError)({statusCode:404,message:"No KYC levels found for the provided IDs"});null==r||r.success(`${l} KYC levels deleted successfully`);return{message:"KYC levels deleted successfully.",count:l}};