"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const fs_1=require("fs"),path_1=require("path"),utils_1=require("./utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk deletes image files by ids",operationId:"bulkDeleteImageFiles",tags:["Admin","Content","Media"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of image file ids to delete"}},required:["ids"]}}}},responses:{200:{description:"Image files deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Bad request if ids are not specified"},404:{description:"Not found if some image files do not exist"},500:{description:"Internal server error"}},requiresAuth:!0,permission:"delete.content.media",logModule:"ADMIN_CMS",logTitle:"Bulk delete media files"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:i}=t;null==s||s.step("Validating image IDs");if(!i||0===i.length){null==s||s.fail("No image IDs provided");throw(0,error_1.createError)({statusCode:400,message:"Image ids are required"})}null==s||s.step(`Deleting ${i.length} image file(s)`);for(const e of i)try{const t=(0,path_1.join)(utils_1.publicDirectory,e.replace(/_/g,"/"));await fs_1.promises.unlink(t);(0,utils_1.filterMediaCache)("/uploads"+e)}catch(e){if("ENOENT"===e.code){null==s||s.fail("Image file not found");throw(0,error_1.createError)({statusCode:404,message:"Image file not found"})}if("EBUSY"===e.code){null==s||s.fail("File is busy or locked");throw(0,error_1.createError)({statusCode:409,message:"File is busy or locked"})}null==s||s.fail("Failed to delete image file");throw(0,error_1.createError)({statusCode:500,message:"Failed to delete image file"})}null==s||s.success(`Successfully deleted ${i.length} image file(s)`);return{message:"Image files deleted successfully"}};