"use strict";function calculateReward(o,e,t,i,s=365){if("SIMPLE"===t)return o*(e/100)*(i/365);if("COMPOUND"===t){const t=e/100,a=i/365;return o*(Math.pow(1+t/s,s*a)-1)}return 0}async function processSinglePosition(o,e,t,i){var s,a;let r=0;for(;r<3;)try{const n=await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.SERIALIZABLE});try{const s=await db_1.models.stakingPosition.findByPk(o.id,{transaction:n,lock:n.LOCK.UPDATE,include:[{model:db_1.models.stakingPool,as:"pool"},{model:db_1.models.user,as:"user"}]});if(!s||"ACTIVE"!==s.status){await n.rollback();(0,broadcast_1.broadcastLog)(i,`Position ${o.id} is no longer active or has already been processed. Current status: ${(null==s?void 0:s.status)||"Not found"}`,"info");return!0}const a=(0,date_fns_1.differenceInDays)(new Date(s.endDate),new Date(s.startDate)),r=calculateReward(s.amount,s.pool.apr,e,a,t);(0,broadcast_1.broadcastLog)(i,`Position ${s.id} (User ${s.user.id}): Staked for ${a} days; calculated reward = ${r.toFixed(2)} ${s.pool.symbol}`,"info");let d=s.amount,c=r,l=0;if(s.pool.adminFeePercentage>0){l=r*(s.pool.adminFeePercentage/100);c=r-l;await db_1.models.stakingAdminEarning.create({poolId:s.pool.id,amount:l,isClaimed:!1,type:"PLATFORM_FEE",currency:s.pool.symbol},{transaction:n});(0,broadcast_1.broadcastLog)(i,`Created admin earning record for pool ${s.pool.id}: ${l.toFixed(2)} ${s.pool.symbol} (${s.pool.adminFeePercentage}% fee)`,"info")}if(s.pool.autoCompound){d=s.amount+c;(0,broadcast_1.broadcastLog)(i,`Position ${s.id} (User ${s.user.id}): Auto-compounding enabled. Updating staked amount from ${s.amount} to ${d.toFixed(2)}`,"info");await s.update({amount:d,status:"COMPLETED",completedAt:new Date},{transaction:n})}else{await s.update({status:"COMPLETED",completedAt:new Date},{transaction:n});await db_1.models.stakingEarningRecord.create({positionId:s.id,amount:c,type:"REGULAR",description:`Earnings for staking position in pool ${s.pool.name}`,isClaimed:!1,claimedAt:null},{transaction:n})}await db_1.models.stakingAdminActivity.create({userId:"SYSTEM",action:"distribute",type:"earnings",relatedId:s.id},{transaction:n});await n.commit();(0,broadcast_1.broadcastLog)(i,`Position ${s.id} (User ${s.user.id}) processed successfully; total reward = ${r.toFixed(2)}, user reward = ${c.toFixed(2)}, admin fee = ${l.toFixed(2)} ${s.pool.symbol}`,"success");try{await(0,emails_1.sendStakingRewardEmail)(s.user,s,s.pool,c);(0,broadcast_1.broadcastLog)(i,`Reward email sent for position ${s.id} (User ${s.user.id})`,"success")}catch(o){console_1.logger.error("STAKING",`Failed to send email for position ${s.id} (User ${s.user.id})`,o);(0,broadcast_1.broadcastLog)(i,`Error sending reward email for position ${s.id} (User ${s.user.id}): ${o.message}`,"error")}try{const o=s.pool.autoCompound?`Your staking position in pool ${s.pool.name} has auto-compounded. Your new staked amount is ${d.toFixed(2)} ${s.pool.symbol}.`:`Your staking position in pool ${s.pool.name} has completed. You earned ${c.toFixed(2)} ${s.pool.symbol}.`;await(0,notifications_1.createNotification)({userId:s.user.id,relatedId:s.id,type:"system",title:s.pool.autoCompound?"Staking Auto-Compounded":"Staking Completed",message:o,link:`/staking/positions/${s.id}`,actions:[{label:"View Position",link:`/staking/positions/${s.id}`,primary:!0}]});(0,broadcast_1.broadcastLog)(i,`Notification created for position ${s.id} (User ${s.user.id})`,"success")}catch(o){console_1.logger.error("STAKING",`Failed to create notification for position ${s.id} (User ${s.user.id})`,o);(0,broadcast_1.broadcastLog)(i,`Error creating notification for position ${s.id} (User ${s.user.id}): ${o.message}`,"error")}try{await(0,affiliate_1.processRewards)(s.user.id,s.amount,"STAKING_LOYALTY",s.pool.symbol);(0,broadcast_1.broadcastLog)(i,`Additional rewards processed for position ${s.id} (User ${s.user.id})`,"success")}catch(o){console_1.logger.error("STAKING",`Failed to process additional rewards for position ${s.id} (User ${s.user.id})`,o);(0,broadcast_1.broadcastLog)(i,`Error processing additional rewards for position ${s.id} (User ${s.user.id}): ${o.message}`,"error")}return!0}catch(e){await n.rollback();(0,broadcast_1.broadcastLog)(i,`Transaction failed for position ${o.id} (User ${null===(s=o.user)||void 0===s?void 0:s.id}): ${e.message}`,"error");console_1.logger.error("STAKING",`Transaction failed for position ${o.id} (User ${null===(a=o.user)||void 0===a?void 0:a.id})`,e);r++;if(r<3){(0,broadcast_1.broadcastLog)(i,`Retrying position ${o.id} (Attempt ${r+1}/3)`,"warning");await new Promise(o=>setTimeout(o,5e3))}}}catch(e){console_1.logger.error("STAKING",`Failed to process position ${o.id}`,e);r++;if(r<3){(0,broadcast_1.broadcastLog)(i,`Retrying position ${o.id} (Attempt ${r+1}/3)`,"warning");await new Promise(o=>setTimeout(o,5e3))}}(0,broadcast_1.broadcastLog)(i,`Failed to process position ${o.id} after 3 attempts`,"error");return!1}async function processWithConcurrency(o,e,t){const i=new Array(o.length);let s=0;const a=new Array(e).fill(0).map(async()=>{for(;s<o.length;){const e=s++;try{i[e]=await t(o[e])}catch(o){i[e]=o}}});await Promise.all(a);return i}async function getSettingsWithFallback(){try{const o=cache_1.CacheManager.getInstance();return await o.getSettings()}catch(o){console_1.logger.warn("STAKING","Cache retrieval failed, falling back to database settings");const e=await db_1.models.settings.findAll(),t=new Map;e.forEach(o=>{t.set(o.key,o.value)});return t}}async function processStakingPositions(){const o="processStakingPositions",e=Date.now();let t=0,i=0;try{(0,broadcast_1.broadcastStatus)(o,"running");(0,broadcast_1.broadcastLog)(o,"Starting processing of staking positions");const s=await getSettingsWithFallback();if(!(!!s.has("stakingAutomaticEarningsDistribution")&&s.get("stakingAutomaticEarningsDistribution"))){(0,broadcast_1.broadcastLog)(o,"Automatic earnings distribution is disabled; skipping staking positions processing.","info");(0,broadcast_1.broadcastStatus)(o,"completed",{skipped:!0});return}const a=s.has("stakingDefaultAprCalculationMethod")?s.get("stakingDefaultAprCalculationMethod"):"SIMPLE",r=s.has("stakingCompoundFrequency")?Number.parseInt(s.get("stakingCompoundFrequency"),10):365,n=s.has("stakingEarningsDistributionTime")?s.get("stakingEarningsDistributionTime"):"00:00",d="true"===process.env.MANUAL_RUN,c=new Date;if(!d){const[e,t]=n.split(":").map(Number),i=new Date(c.getFullYear(),c.getMonth(),c.getDate(),e,t);if(Math.abs(c.getTime()-i.getTime())>DISTRIBUTION_TOLERANCE_MS){(0,broadcast_1.broadcastLog)(o,`Current time (${c.toTimeString().slice(0,5)}) is not within the tolerance window of the distribution time (${n}). Checking for missed executions...`,"info");const e=await db_1.models.stakingPosition.count({where:{status:"ACTIVE",endDate:{[sequelize_1.Op.lt]:(0,date_fns_1.addDays)(c,-1)}}});if(0===e){(0,broadcast_1.broadcastLog)(o,"No missed positions found. Skipping processing.","info");(0,broadcast_1.broadcastStatus)(o,"completed",{skipped:!0});return}(0,broadcast_1.broadcastLog)(o,`Found ${e} positions that were missed in previous executions. Proceeding with processing.`,"warning")}}const l=await db_1.models.stakingPosition.findAll({where:{status:"ACTIVE",endDate:{[sequelize_1.Op.lt]:c}},include:[{model:db_1.models.stakingPool,as:"pool",attributes:["id","name","symbol","apr","lockPeriod","earningFrequency","autoCompound","adminFeePercentage"]},{model:db_1.models.user,as:"user",attributes:["id","email","firstName","lastName"]}],order:[["endDate","ASC"]],lock:sequelize_1.Transaction.LOCK.UPDATE,skipLocked:!0});(0,broadcast_1.broadcastLog)(o,`Found ${l.length} staking positions to process`);if(0===l.length){(0,broadcast_1.broadcastStatus)(o,"completed",{duration:Date.now()-e,processed:0});return}const u=await processWithConcurrency(l,MAX_CONCURRENCY,async e=>{var s,n;try{if(await processSinglePosition(e,a,r,o)){t++;return{success:!0,positionId:e.id}}i++;return{success:!1,positionId:e.id,error:"Failed after retries"}}catch(t){i++;(0,broadcast_1.broadcastLog)(o,`Error processing position ${e.id} (User ${null===(s=e.user)||void 0===s?void 0:s.id}): ${t.message}`,"error");console_1.logger.error("STAKING",`Error processing position ${e.id} (User ${null===(n=e.user)||void 0===n?void 0:n.id})`,t);return{success:!1,positionId:e.id,error:t.message}}}),g=u.filter(o=>o.success).length,p=u.filter(o=>!o.success).length;(0,broadcast_1.broadcastLog)(o,`Processing summary: ${g} positions processed successfully, ${p} positions failed`,g>0?"success":"warning");if(p>0){const e=u.filter(o=>!o.success).map(o=>o.positionId);console_1.logger.error("STAKING",`Failed to process ${p} positions: ${e.join(", ")}`);try{const t=await db_1.models.user.findAll({include:[{model:db_1.models.role,as:"role",where:{name:"Super Admin"}}],limit:1});t.length>0&&await notification_1.notificationService.send({userId:t[0].id,type:"SYSTEM",channels:["IN_APP"],idempotencyKey:`staking_failed_${o}_${(new Date).toISOString().split("T")[0]}`,data:{title:"Staking Reward Processing Failed",message:`${e.length} staking rewards failed to process. Please review immediately.`,details:JSON.stringify({failedPositionIds:e,executionTime:(new Date).toISOString(),cronName:o})},priority:"HIGH"});(0,broadcast_1.broadcastLog)(o,"Created admin task for failed positions","info")}catch(o){console_1.logger.error("STAKING","Failed to create admin task for failed positions",o)}}(0,broadcast_1.broadcastStatus)(o,"completed",{duration:Date.now()-e,processed:g,failed:p});(0,broadcast_1.broadcastLog)(o,"Processing of staking positions completed","success")}catch(s){console_1.logger.error("STAKING","Processing of staking positions failed",s);(0,broadcast_1.broadcastStatus)(o,"failed",{duration:Date.now()-e,processed:t,failed:i,skipped:0,error:s.message});(0,broadcast_1.broadcastLog)(o,`Processing of staking positions failed: ${s.message}`,"error");throw s}}Object.defineProperty(exports,"__esModule",{value:!0});exports.processStakingPositions=processStakingPositions;const db_1=require("@b/db"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),emails_1=require("@b/utils/emails"),notifications_1=require("@b/utils/notifications"),affiliate_1=require("@b/utils/affiliate"),broadcast_1=require("@b/cron/broadcast"),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console"),notification_1=require("@b/services/notification"),DISTRIBUTION_TOLERANCE_MS=18e5,MAX_CONCURRENCY=5,MAX_RETRY_ATTEMPTS=3,RETRY_DELAY_MS=5e3;