"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get User's Staking Earnings",description:"Retrieves all staking earnings for the authenticated user across all positions.",operationId:"getUserStakingEarnings",tags:["Staking","User","Earnings"],requiresAuth:!0,logModule:"STAKE",logTitle:"Get User Earnings",parameters:[{index:0,name:"claimed",in:"query",required:!1,schema:{type:"boolean"},description:"Filter by claimed status"},{index:1,name:"poolId",in:"query",required:!1,schema:{type:"string"},description:"Filter by pool ID"},{index:2,name:"timeframe",in:"query",required:!1,schema:{type:"string",enum:["week","month","year","all"]},description:"Timeframe for earnings data"}],responses:{200:{description:"Earnings retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{earnings:{type:"array",items:{type:"object"}},summary:{type:"object",properties:{total:{type:"number"},claimed:{type:"number"},unclaimed:{type:"number"},byToken:{type:"array",items:{type:"object",properties:{tokenSymbol:{type:"string"},total:{type:"number"},claimed:{type:"number"},unclaimed:{type:"number"}}}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:i,ctx:r}=e;null==r||r.step("Validating user authentication");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a=new Date;let n;switch(i.timeframe){case"week":n=new Date(a);n.setDate(a.getDate()-7);break;case"month":n=new Date(a);n.setMonth(a.getMonth()-1);break;case"year":n=new Date(a);n.setFullYear(a.getFullYear()-1);break;default:n=new Date(0)}const o={userId:t.id};i.poolId&&(o.poolId=i.poolId);const s=(await db_1.models.stakingPosition.findAll({where:o,attributes:["id"]})).map(e=>e.id);if(0===s.length)return{earnings:[],summary:{total:0,claimed:0,unclaimed:0,byToken:[]}};const l={positionId:{[sequelize_1.Op.in]:s},createdAt:{[sequelize_1.Op.gte]:n}};void 0!==i.claimed&&(l.isClaimed="true"===i.claimed);const d=await db_1.models.stakingEarningRecord.findAll({where:l,include:[{model:db_1.models.stakingPosition,as:"position",attributes:["id","amount","status","poolId"],include:[{model:db_1.models.stakingPool,as:"pool",attributes:["id","name","apr","symbol","icon"]}]}],order:[["createdAt","DESC"]]}),u=d.reduce((e,t)=>e+t.amount,0),c=d.filter(e=>e.isClaimed).reduce((e,t)=>e+t.amount,0),m=u-c,p={};d.forEach(e=>{const t=e.position.pool.symbol;p[t]||(p[t]={tokenSymbol:t,tokenIcon:e.position.pool.icon,total:0,claimed:0,unclaimed:0});p[t].total+=e.amount;e.isClaimed?p[t].claimed+=e.amount:p[t].unclaimed+=e.amount});const y=await db_1.models.stakingEarningRecord.findAll({attributes:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"date"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalAmount"]],where:l,group:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],order:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"ASC"]],raw:!0});null==r||r.success(`Retrieved ${d.length} earning records`);return{earnings:d,summary:{total:u,claimed:c,unclaimed:m,byToken:Object.values(p),earningsByDay:y}}};