"use strict";async function handleP2PTradeTimeouts(e){var t,r,a,o,i,n,l,d,s,u;try{null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Starting P2P trade timeout handler");const{CacheManager:u}=await Promise.resolve().then(()=>__importStar(require("@b/utils/cache"))),c=u.getInstance(),f=await c.getSetting("p2pDefaultPaymentWindow")||30,p=new Date;p.setMinutes(p.getMinutes()-10);const g=(await db_1.models.p2pTrade.findAll({where:{status:{[sequelize_1.Op.in]:["PENDING","PAYMENT_SENT"]},createdAt:{[sequelize_1.Op.lt]:p}},include:[{model:db_1.models.p2pOffer,as:"offer",attributes:["id","currency","walletType","userId","tradeSettings"]}]})).filter(e=>{var t,r;const a=(null===(r=null===(t=e.offer)||void 0===t?void 0:t.tradeSettings)||void 0===r?void 0:r.autoCancel)||f;return(new Date).getTime()-new Date(e.createdAt).getTime()>60*a*1e3});if(g.length>0){null===(r=null==e?void 0:e.step)||void 0===r||r.call(e,`Processing ${g.length} expired trades`);console_1.logger.info("P2P",`Processing ${g.length} expired trades`)}for(const t of g){null===(a=null==e?void 0:e.step)||void 0===a||a.call(e,`Processing expired trade ${t.id}`);if(!/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(t.id)){console_1.logger.warn("P2P",`Invalid trade ID detected: ${t.id}, deleting invalid trade`);try{await db_1.models.p2pTrade.destroy({where:{id:t.id},force:!0});console_1.logger.info("P2P",`Deleted invalid trade ${t.id}`)}catch(e){console_1.logger.error("P2P",`Failed to delete invalid trade ${t.id}`,e)}continue}const r=await db_1.sequelize.transaction();try{const a=await db_1.models.p2pTrade.findByPk(t.id,{lock:!0,transaction:r}),s=(null===(i=null===(o=t.offer)||void 0===o?void 0:o.tradeSettings)||void 0===i?void 0:i.autoCancel)||f,u=(new Date).getTime()-new Date(a.createdAt).getTime()>60*s*1e3;if(!a||!["PENDING","PAYMENT_SENT"].includes(a.status)||!u){await r.rollback();continue}if(("PENDING"===a.status||"PAYMENT_SENT"===a.status)&&t.offer)try{const e=await(0,utils_1.getWalletSafe)(a.sellerId,t.offer.walletType,t.offer.currency||a.currency);if(e){const o=Math.min(t.amount,e.inOrder);if(o>0){const i=`p2p_timeout_release_${t.id}`;await wallet_1.walletService.release({idempotencyKey:i,userId:a.sellerId,walletId:e.id,walletType:t.offer.walletType,currency:t.offer.currency||a.currency,amount:o,operationType:"P2P_TRADE_EXPIRED",description:`Release ${o} ${t.offer.currency||a.currency} - P2P trade expired`,metadata:{tradeId:t.id,offerId:t.offerId,expiredAt:(new Date).toISOString(),reason:"timeout"},transaction:r});console_1.logger.info("P2P",`Released ${o} ${t.offer.currency||a.currency} (${t.offer.walletType}) for seller ${a.sellerId}`);console_1.logger.debug("P2P",`Trade unlock details: amount=${t.amount}, prevInOrder=${e.inOrder}`);o<t.amount&&console_1.logger.warn("P2P",`Partial unlock - inOrder was less than trade amount: tradeId=${t.id}, amount=${t.amount}, available=${e.inOrder}, unlocked=${o}`)}else console_1.logger.warn("P2P",`No funds to unlock - inOrder is already 0: tradeId=${t.id}, amount=${t.amount}, currentInOrder=${e.inOrder}`)}}catch(e){console_1.logger.error("P2P",`Failed to release wallet funds for trade ${t.id}`,e)}let c=a.timeline||[];if("string"==typeof c)try{c=JSON.parse(c)}catch(e){c=[]}Array.isArray(c)||(c=[]);c.push({event:"TRADE_EXPIRED",message:"Trade expired due to timeout",userId:null,createdAt:(new Date).toISOString()});await a.update({status:"EXPIRED",timeline:c,expiredAt:new Date},{transaction:r});if(t.offerId){const e=await db_1.models.p2pOffer.findByPk(t.offerId,{lock:!0,transaction:r});if(e&&"ACTIVE"===e.status){const a=(0,json_parser_1.parseAmountConfig)(e.amountConfig),o=null!==(n=a.originalTotal)&&void 0!==n?n:a.total+t.amount,i=a.total+t.amount,l=Math.min(i,o);if(l>a.total){await e.update({amountConfig:{...a,total:l,originalTotal:o}},{transaction:r});console_1.logger.debug("P2P",`Restored offer amount: offerId=${e.id}, tradeAmount=${t.amount}, prevTotal=${a.total}, newTotal=${l}`)}else console_1.logger.debug("P2P",`Skipped restoration - at or above limit: offerId=${e.id}, currentTotal=${a.total}, max=${o}`)}}try{await db_1.models.p2pActivityLog.create({userId:t.sellerId,type:"TRADE_EXPIRED",action:"EXPIRED",relatedEntity:"TRADE",relatedEntityId:t.id,details:JSON.stringify({previousStatus:a.status,amount:t.amount,currency:null===(l=t.offer)||void 0===l?void 0:l.currency,buyerId:t.buyerId,sellerId:t.sellerId,systemGenerated:!0})},{transaction:r})}catch(e){console_1.logger.warn("P2P",`Failed to create activity log for trade ${t.id}, continuing with expiration`,e)}await r.commit();(0,notifications_1.notifyTradeEvent)(t.id,"TRADE_EXPIRED",{buyerId:t.buyerId,sellerId:t.sellerId,amount:t.amount,currency:t.offer.currency},e).catch(e=>console_1.logger.error("P2P","Failed to notify trade event",e));null===(d=null==e?void 0:e.step)||void 0===d||d.call(e,`Successfully expired trade ${t.id}`);console_1.logger.info("P2P",`Successfully expired trade ${t.id}`)}catch(e){await r.rollback();console_1.logger.error("P2P",`Failed to expire trade ${t.id}`,e)}}await handleExpiredOffers(e);null===(s=null==e?void 0:e.success)||void 0===s||s.call(e,"P2P trade timeout handler completed successfully")}catch(t){null===(u=null==e?void 0:e.fail)||void 0===u||u.call(e,t.message||"Trade timeout handler error");console_1.logger.error("P2P","Trade timeout handler error",t)}}async function handleExpiredOffers(e){var t,r,a,o,i,n;try{null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Checking for expired offers");const n=30,l=new Date;l.setDate(l.getDate()-n);const d=await db_1.models.p2pOffer.findAll({where:{status:"ACTIVE",updatedAt:{[sequelize_1.Op.lt]:l},[sequelize_1.Op.or]:[(0,sequelize_1.literal)("JSON_EXTRACT(`amountConfig`, '$.total') = 0"),(0,sequelize_1.literal)("JSON_EXTRACT(`amountConfig`, '$.total') IS NULL"),(0,sequelize_1.literal)("CAST(JSON_EXTRACT(`amountConfig`, '$.total') AS DECIMAL(36,18)) <= 0")]}});if(d.length>0){null===(r=null==e?void 0:e.step)||void 0===r||r.call(e,`Processing ${d.length} expired offers`);console_1.logger.info("P2P",`Processing ${d.length} expired offers`)}for(const t of d){null===(a=null==e?void 0:e.step)||void 0===a||a.call(e,`Processing expired offer ${t.id}`);try{await t.update({status:"EXPIRED",adminNotes:`Auto-expired due to inactivity and zero balance at ${(new Date).toISOString()}`});await db_1.models.p2pActivityLog.create({userId:t.userId,type:"OFFER_EXPIRED",action:"EXPIRED",relatedEntity:"OFFER",relatedEntityId:t.id,details:JSON.stringify({reason:"inactivity_and_zero_balance",lastUpdated:t.updatedAt,systemGenerated:!0})});const{notifyOfferEvent:r}=await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/p2p/utils/notifications")));r(t.id,"OFFER_EXPIRED",{reason:"Inactivity and zero balance"},e).catch(e=>console_1.logger.error("P2P","Failed to notify offer event",e));null===(o=null==e?void 0:e.step)||void 0===o||o.call(e,`Expired offer ${t.id}`);console_1.logger.info("P2P",`Expired offer ${t.id}`)}catch(e){console_1.logger.error("P2P",`Failed to expire offer ${t.id}`,e)}}null===(i=null==e?void 0:e.success)||void 0===i||i.call(e,"Expired offers handled successfully")}catch(t){null===(n=null==e?void 0:e.fail)||void 0===n||n.call(e,t.message||"Offer expiry handler error");console_1.logger.error("P2P","Offer expiry handler error",t)}}async function archiveOldP2PTrades(){try{const e=90,t=new Date;t.setDate(t.getDate()-e);const r=await db_1.models.p2pTrade.findAll({where:{status:{[sequelize_1.Op.in]:["COMPLETED","CANCELLED","EXPIRED"]},updatedAt:{[sequelize_1.Op.lt]:t},archived:{[sequelize_1.Op.or]:[!1,null]}},limit:100});r.length>0&&console_1.logger.info("P2P",`Archiving ${r.length} trades`);for(const e of r)try{await e.update({archived:!0,archivedAt:new Date})}catch(t){console_1.logger.error("P2P",`Failed to archive trade ${e.id}`,t)}}catch(e){console_1.logger.error("P2P","Trade archival error",e)}}async function updateP2PReputationScores(){try{const e=await db_1.models.p2pTrade.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("buyerId")),"userId"]],where:{createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-2592e6)}},raw:!0}),t=await db_1.models.p2pTrade.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("sellerId")),"userId"]],where:{createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-2592e6)}},raw:!0}),r=[...new Set([...e.map(e=>e.userId),...t.map(e=>e.userId)])];r.length>0&&console_1.logger.info("P2P",`Updating reputation for ${r.length} users`);for(const e of r)try{const t=await db_1.models.p2pTrade.count({where:{[sequelize_1.Op.or]:[{buyerId:e},{sellerId:e}],status:"COMPLETED"}}),r=await db_1.models.p2pTrade.count({where:{[sequelize_1.Op.or]:[{buyerId:e},{sellerId:e}],status:{[sequelize_1.Op.ne]:"PENDING"}}}),a=await db_1.models.p2pDispute.count({where:{[sequelize_1.Op.or]:[{reportedById:e},{againstId:e}],status:"RESOLVED"}}),o=await db_1.models.p2pReview.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("rating")),"avgRating"]],where:{reviewedUserId:e},raw:!0});let i=50;if(r>0){i+=30*(t/r)}o&&o.avgRating&&(i+=o.avgRating/5*20);i-=Math.min(5*a,20);i=Math.max(0,Math.min(100,Math.round(i)));if(10===t||50===t||100===t){const{notifyReputationEvent:r}=await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/p2p/utils/notifications")));r(e,"REPUTATION_MILESTONE",{milestone:t,reputationScore:i}).catch(e=>console_1.logger.error("P2P","Failed to notify reputation event",e))}}catch(t){console_1.logger.error("P2P",`Failed to update reputation for user ${e}`,t)}}catch(e){console_1.logger.error("P2P","Reputation update error",e)}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var o=Object.getOwnPropertyDescriptor(t,r);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,o)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),o=0;o<a.length;o++)"default"!==a[o]&&__createBinding(r,t,a[o]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.p2pJobs=void 0;exports.handleP2PTradeTimeouts=handleP2PTradeTimeouts;exports.archiveOldP2PTrades=archiveOldP2PTrades;exports.updateP2PReputationScores=updateP2PReputationScores;const db_1=require("@b/db"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/wallet/utils"),notifications_1=require("@b/api/(ext)/p2p/utils/notifications"),json_parser_1=require("@b/api/(ext)/p2p/utils/json-parser"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");exports.p2pJobs={handleTradeTimeouts:{name:"p2p-trade-timeout",schedule:"*/5 * * * *",handler:handleP2PTradeTimeouts},archiveTrades:{name:"p2p-archive-trades",schedule:"0 2 * * *",handler:archiveOldP2PTrades},updateReputation:{name:"p2p-update-reputation",schedule:"0 * * * *",handler:updateP2PReputationScores}};