"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,r){void 0===r&&(r=a);var i=Object.getOwnPropertyDescriptor(t,a);i&&!("get"in i?!t.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return t[a]}});Object.defineProperty(e,r,i)}:function(e,t,a,r){void 0===r&&(r=a);e[r]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var a={};if(null!=t)for(var r=e(t),i=0;i<r.length;i++)"default"!==r[i]&&__createBinding(a,t,r[i]);__setModuleDefault(a,t);return a}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");exports.metadata={summary:"Create Payment Method",description:"Creates a new custom payment method for the authenticated user.",operationId:"createPaymentMethod",tags:["P2P","Payment Method"],requiresAuth:!0,middleware:["p2pPaymentMethodCreateRateLimit"],logModule:"P2P_PAYMENT",logTitle:"Create payment method",requestBody:{description:"Payment method data",required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string"},icon:{type:"string"},description:{type:"string"},instructions:{type:"string"},metadata:{type:"object",description:"Flexible key-value pairs for payment details (e.g., { 'PayPal Email': 'user@example.com' })",additionalProperties:{type:"string"}},processingTime:{type:"string"},available:{type:"boolean"}},required:["name"]}}}},responses:{200:{description:"Payment method created successfully."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{body:t,user:a,ctx:r}=e;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Validating payment method data");const{validatePaymentMethod:i}=await Promise.resolve().then(()=>__importStar(require("../utils/validation")));try{const e=i(t);null==r||r.step("Checking user payment method limits");const o=await db_1.models.p2pPaymentMethod.count({where:{userId:a.id,deletedAt:null}}),n=20;if(o>=n)throw(0,error_1.createError)({statusCode:400,message:`You can only have up to ${n} payment methods`});if(await db_1.models.p2pPaymentMethod.findOne({where:{userId:a.id,name:e.name,deletedAt:null}}))throw(0,error_1.createError)({statusCode:400,message:"You already have a payment method with this name. Please use a different name or edit your existing method."});let s=null;if(t.metadata&&"object"==typeof t.metadata&&!Array.isArray(t.metadata)){const e={},a=20;let r=0;for(const[i,o]of Object.entries(t.metadata)){if(r>=a)break;if("string"==typeof i&&"string"==typeof o){const t=i.trim().substring(0,100),a=o.trim().substring(0,500);if(t&&a){e[t]=a;r++}}}Object.keys(e).length>0&&(s=e)}null==r||r.step("Creating payment method");const d=await db_1.models.p2pPaymentMethod.create({userId:a.id,...e,metadata:s,available:"boolean"!=typeof t.available||t.available,isGlobal:!1,popularityRank:999});console_1.logger.info("P2P_PAYMENT_METHOD",`Created custom payment method: ${d.id} - ${d.name} for user ${a.id}`);await db_1.models.p2pActivityLog.create({userId:a.id,type:"PAYMENT_METHOD",action:"CREATED",relatedEntity:"PAYMENT_METHOD",relatedEntityId:d.id,details:JSON.stringify({name:e.name,icon:e.icon})});null==r||r.success(`Created payment method: ${e.name}`);return{message:"Payment method created successfully.",paymentMethod:{id:d.id,userId:d.userId,name:d.name,icon:d.icon,description:d.description,instructions:d.instructions,metadata:d.metadata,processingTime:d.processingTime,available:d.available,popularityRank:d.popularityRank,createdAt:d.createdAt}}}catch(e){if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:"Failed to create payment method: "+e.message})}};