"use strict";async function handler(e){var t,r,o,n,i,a,s,l,u,d,c,f;const{user:m,body:p,ctx:y}=e;if(!(null==m?void 0:m.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==y||y.step("Validating required fields");if(!(null===(t=p.locationSettings)||void 0===t?void 0:t.country))throw(0,error_1.createError)({statusCode:400,message:"Location country is required for P2P offers"});if(!(null===(o=null===(r=p.tradeSettings)||void 0===r?void 0:r.termsOfTrade)||void 0===o?void 0:o.trim()))throw(0,error_1.createError)({statusCode:400,message:"Trade terms are required for P2P offers"});console.log("[P2P Offer Create] Received body:",{type:p.type,currency:p.currency,paymentMethodIds:p.paymentMethodIds});if(!p.paymentMethodIds||!Array.isArray(p.paymentMethodIds)||0===p.paymentMethodIds.length){console.error("[P2P Offer Create] Invalid payment methods:",p.paymentMethodIds);throw(0,error_1.createError)({statusCode:400,message:"At least one payment method is required for P2P offers"})}null==y||y.step("Checking offer type and requirements");let g=null,h=0;if("SELL"===p.type){null==y||y.step("Checking seller balance for SELL offer");h=(null===(n=p.amountConfig)||void 0===n?void 0:n.total)||0;if(h<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid amount specified for sell offer"});g=await(0,utils_1.getWalletSafe)(m.id,p.walletType,p.currency,!1,y);if(!g)throw(0,error_1.createError)({statusCode:400,message:`You don't have a ${p.currency} ${p.walletType} wallet. Please create one first.`});const e=g.balance-g.inOrder;if(e<h)throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. Available: ${e} ${p.currency}, Required: ${h} ${p.currency}. Please deposit more funds to your ${p.walletType} wallet.`})}null==y||y.step("Validating offer configuration and settings");const P=cache_1.CacheManager.getInstance(),v=await P.getSetting("p2pAutoApproveOffers"),C=!0===v||"true"===v,_=["amountConfig","priceConfig","tradeSettings","locationSettings","userRequirements"],w={};for(const e of _)if(void 0!==p[e]&&null!==p[e]){const t=p[e];if("string"==typeof t)try{w[e]=JSON.parse(t)}catch(t){throw(0,error_1.createError)({statusCode:400,message:`Invalid JSON for field ${e}`})}else"object"==typeof t&&(w[e]=t)}else w[e]=null;w.tradeSettings&&void 0===w.tradeSettings.kycRequired&&(w.tradeSettings.kycRequired=!1);const b=(null===(i=w.priceConfig)||void 0===i?void 0:i.currency)||"USD",I=await P.getSetting("p2pMinimumTradeAmount"),O=await P.getSetting("p2pMaximumTradeAmount"),S=(null===(a=w.amountConfig)||void 0===a?void 0:a.min)||0,q=(null===(s=w.amountConfig)||void 0===s?void 0:s.max)||(null===(l=w.amountConfig)||void 0===l?void 0:l.total)||0;if(I&&S<I)throw(0,error_1.createError)({statusCode:400,message:`Minimum trade amount cannot be less than platform minimum of ${I} ${b}`});if(O&&q>O)throw(0,error_1.createError)({statusCode:400,message:`Maximum trade amount cannot exceed platform maximum of ${O} ${b}`});const{validateMinimumTradeAmount:E}=await Promise.resolve().then(()=>__importStar(require("../utils/fees")));if((null===(u=w.amountConfig)||void 0===u?void 0:u.min)&&(null===(d=w.priceConfig)||void 0===d?void 0:d.finalPrice)){const e=w.amountConfig.min/w.priceConfig.finalPrice,t=await E(e,p.currency);if(!t.valid&&t.minimum)throw(0,error_1.createError)({statusCode:400,message:`Minimum trade amount for ${p.currency} is ${t.minimum} ${p.currency}. Current minimum converts to ${e.toFixed(8)} ${p.currency}.`})}null==y||y.step("Creating offer record");const M=await db_1.sequelize.transaction();try{const e=await db_1.models.p2pOffer.create({userId:m.id,type:p.type,currency:p.currency,walletType:p.walletType,priceCurrency:b,amountConfig:w.amountConfig,priceConfig:w.priceConfig,tradeSettings:w.tradeSettings,locationSettings:w.locationSettings,userRequirements:w.userRequirements,status:C?"ACTIVE":"PENDING_APPROVAL",views:0,systemTags:[],adminNotes:null},{transaction:M});if("SELL"===p.type&&g&&h>0){null==y||y.step(`Locking ${h} ${p.currency} for SELL offer`);const t=`p2p_offer_lock_${e.id}`;await wallet_1.walletService.hold({idempotencyKey:t,userId:m.id,walletId:g.id,walletType:p.walletType,currency:p.currency,amount:h,operationType:"P2P_OFFER_LOCK",description:`Lock ${h} ${p.currency} for P2P SELL offer`,metadata:{offerId:e.id,offerType:p.type},transaction:M});console.log("[P2P Offer Create] SELL offer - funds locked:",{userId:m.id,walletId:g.id,walletType:p.walletType,currency:p.currency,amount:h,previousInOrder:g.inOrder,newInOrder:g.inOrder+h})}const t=Array.isArray(p.paymentMethodIds)?p.paymentMethodIds:[];if(t.length){null==y||y.step(`Validating and associating ${t.length} payment method(s)`);console.log("[P2P Offer Create] Validating payment method IDs:",t);const r=await db_1.models.p2pPaymentMethod.findAll({where:{id:t,[sequelize_1.Op.or]:[{userId:null},{userId:m.id}]},transaction:M});console.log("[P2P Offer Create] Found payment methods:",r.map(e=>({id:e.id,name:e.name,userId:e.userId})));if(r.length!==t.length){const e=r.map(e=>e.id),o=t.filter(t=>!e.includes(t));console.error("[P2P Offer Create] Missing payment method IDs:",o);throw(0,error_1.createError)({statusCode:400,message:`Invalid payment method IDs: ${o.join(", ")}. Please ensure all payment methods are properly created first.`})}await e.setPaymentMethods(r,{transaction:M});console.log("[P2P Offer Create] Associated payment methods successfully")}await M.commit();await e.reload({include:[{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name","icon"],through:{attributes:[]}}]});const r=C?"ACTIVE":"PENDING_APPROVAL";null==y||y.success(`Created ${p.type} offer for ${null===(c=p.amountConfig)||void 0===c?void 0:c.total} ${p.currency} (${r})`);return{message:"Offer created successfully.",offer:e}}catch(e){await M.rollback();throw(0,error_1.createError)({statusCode:null!==(f=e.statusCode)&&void 0!==f?f:500,message:e.message?`Internal Server Error: ${e.message}`:"Internal Server Error"})}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r);e[o]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var o=e(t),n=0;n<o.length;n++)"default"!==o[n]&&__createBinding(r,t,o[n]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.default=handler;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("@b/api/finance/wallet/utils"),sequelize_1=require("sequelize"),cache_1=require("@b/utils/cache"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Create a P2P Offer",description:"Creates a new offer with structured configurations for the authenticated user, and associates payment methods.",operationId:"createP2POffer",tags:["P2P","Offer"],requiresAuth:!0,middleware:["p2pOfferCreateRateLimit"],logModule:"P2P_OFFER",logTitle:"Create P2P offer",requestBody:{description:"Complete P2P offer payload",required:!0,content:{"application/json":{schema:{type:"object",properties:{type:{type:"string",enum:["BUY","SELL"]},currency:{type:"string"},walletType:{type:"string",enum:["FIAT","SPOT","ECO"]},amountConfig:{type:"object",properties:{total:{type:"number"},min:{type:"number"},max:{type:"number"},availableBalance:{type:"number"}},required:["total"]},priceConfig:{type:"object",properties:{model:{type:"string",enum:["FIXED","MARGIN"]},value:{type:"number"},marketPrice:{type:"number"},finalPrice:{type:"number"}},required:["model","value","finalPrice"]},tradeSettings:{type:"object",properties:{autoCancel:{type:"number"},kycRequired:{type:"boolean",default:!1},visibility:{type:"string",enum:["PUBLIC","PRIVATE"]},termsOfTrade:{type:"string",minLength:1},additionalNotes:{type:"string"}},required:["autoCancel","visibility","termsOfTrade"]},locationSettings:{type:"object",properties:{country:{type:"string",minLength:1},region:{type:"string"},city:{type:"string"},restrictions:{type:"array",items:{type:"string"}}},required:["country"]},userRequirements:{type:"object",properties:{minCompletedTrades:{type:"number"},minSuccessRate:{type:"number"},minAccountAge:{type:"number"},trustedOnly:{type:"boolean"}}},paymentMethodIds:{type:"array",items:{type:"string",format:"uuid"},description:"Array of P2P payment‐method IDs to attach",minItems:1}},required:["type","currency","walletType","amountConfig","priceConfig","tradeSettings","locationSettings","paymentMethodIds"]}}}},responses:{200:{description:"Offer created successfully."},400:{description:"Bad Request."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};