"use strict";async function getMarketPrice(e,t){switch(t){case"FIAT":return(0,utils_1.getFiatPriceInUSD)(e);case"SPOT":return(0,utils_1.getSpotPriceInUSD)(e);case"ECO":return(0,utils_1.getEcoPriceInUSD)(e);default:return null}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),json_parser_1=require("@b/api/(ext)/p2p/utils/json-parser"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils");exports.metadata={summary:"Submit Guided Matching Criteria",description:"Finds matching offers based on guided matching criteria provided by the authenticated user.",operationId:"submitP2PGuidedMatching",tags:["P2P","Guided Matching"],requiresAuth:!0,logModule:"P2P_MATCHING",logTitle:"Submit guided matching criteria",requestBody:{description:"Guided matching criteria",required:!0,content:{"application/json":{schema:{type:"object",properties:{tradeType:{type:"string",enum:["buy","sell"]},cryptocurrency:{type:"string"},amount:{type:"string"},paymentMethods:{type:"array",items:{type:"string"}},pricePreference:{type:"string"},traderPreference:{type:"string"},location:{type:"string"}},required:["tradeType","cryptocurrency","amount","paymentMethods","pricePreference","traderPreference","location"]}}}},responses:{200:{description:"Matching results retrieved successfully."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};const calculateMatchScore=({price:e,bestPrice:t,completionRate:r,verified:i,methodOverlap:a})=>{let n=0;n+=t&&e?40*(1-Math.abs((e-t)/t)):0;n+=.3*(r||0);n+=i?20:0;n+=a?10:0;return Math.round(n)};exports.default=async e=>{const{body:t,user:r,ctx:i}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==i||i.step("Parsing matching criteria");try{const e=parseFloat(t.amount)||0;null==i||i.step(`Finding ${t.tradeType} offers for ${t.cryptocurrency}`);const r=await db_1.models.p2pOffer.findAll({where:{currency:t.cryptocurrency,type:t.tradeType.toUpperCase(),status:"ACTIVE",...e&&{"amountConfig.min":{[sequelize_1.Op.lte]:e},"amountConfig.max":{[sequelize_1.Op.gte]:e}},...t.location&&"any"!==t.location&&{"locationSettings.country":t.location}},include:[{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name"],through:{attributes:[]}},{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar","profile","emailVerified"],include:[{model:db_1.models.p2pTrade,as:"p2pTrades",attributes:["id","status"]},{model:db_1.models.p2pReview,as:"p2pReviews",attributes:["communicationRating","speedRating","trustRating"],where:{revieweeId:{[sequelize_1.Op.col]:"user.id"}},required:!1}]}],limit:30,order:[["priceConfig.finalPrice","ASC"]]});if(!r.length)return{matches:[],matchCount:0,estimatedSavings:0,bestPrice:0};const a=r.map(e=>(0,json_parser_1.parsePriceConfig)(e.priceConfig).finalPrice),n="buy"===t.tradeType?Math.min(...a):Math.max(...a);let o=null;try{o=await getMarketPrice(t.cryptocurrency,r[0].walletType)}catch(e){o=a.reduce((e,t)=>e+t,0)/(a.length||1)}const s=new Set(t.paymentMethods);null==i||i.step(`Scoring and ranking ${r.length} matching offers`);const c=r.map(e=>{var t;const r=(0,json_parser_1.parsePriceConfig)(e.priceConfig),i=(0,json_parser_1.parseAmountConfig)(e.amountConfig),a=(e.paymentMethods||[]).map(e=>e.name),o=(e.paymentMethods||[]).map(e=>e.id).some(e=>s.has(e))?1:0,c=e.user;let l=(null==c?void 0:c.firstName)||"Trader";(null==c?void 0:c.lastName)&&(l+=" "+c.lastName);const d=(null==c?void 0:c.p2pTrades)||[],u=d.filter(e=>"COMPLETED"===e.status).length,p=d.length||1,m=Math.round(u/p*100),g=(null==c?void 0:c.p2pReviews)||[];let h=0;if(g.length>0){h=g.reduce((e,t)=>e+(t.communicationRating||0)+(t.speedRating||0)+(t.trustRating||0),0)/(3*g.length);h=Math.round(10*h)/10}const y=!!(null==c?void 0:c.emailVerified);return{id:e.id,type:e.type.toLowerCase(),coin:e.currency,walletType:e.walletType,price:r.finalPrice,minLimit:i.min,maxLimit:i.max,availableAmount:i.availableBalance||i.total,paymentMethods:a,matchScore:calculateMatchScore({price:r.finalPrice,bestPrice:n,completionRate:m,verified:y,methodOverlap:o}),trader:{id:null==c?void 0:c.id,name:l,avatar:null==c?void 0:c.avatar,completedTrades:u,completionRate:m,verified:y,responseTime:5,avgRating:h},benefits:[m>90?"High completion rate":"Solid completion",h>90?"Highly rated":"Community trusted",o?"Your preferred payment method":"Flexible payments",y?"KYC Verified":"Active user"],location:(null===(t=e.locationSettings)||void 0===t?void 0:t.country)||"Global",createdAt:e.createdAt,updatedAt:e.updatedAt}});c.sort((e,t)=>t.matchScore-e.matchScore);let l=0;if(o&&n){"buy"===t.tradeType?l=(o-n)*e:"sell"===t.tradeType&&(l=(n-o)*e);l=Math.round(100*(l+Number.EPSILON))/100}null==i||i.success(`Found ${c.length} matching offers (savings: ${l})`);return{matches:c,matchCount:c.length,estimatedSavings:l,bestPrice:n}}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};