"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get ICO Platform Statistics",description:"Retrieves ICO platform statistics including total raised funds, growth percentage, successful offerings count, total investors, and average ROI. Calculations are now based on all non-rejected transactions and monthly comparisons.",operationId:"getIcoStats",tags:["ICO","Stats"],logModule:"ICO",logTitle:"Get ICO Stats",requiresAuth:!1,responses:{200:{description:"ICO platform statistics retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{projectsLaunched:{type:"number"},totalRaised:{type:"number"},totalInvestors:{type:"number"},raisedGrowth:{type:"number"},successfulOfferings:{type:"number"},offeringsGrowth:{type:"number"},investorsGrowth:{type:"number"},averageROI:{type:"number"},roiGrowth:{type:"number"}}}}}},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching ICO stats");if(!db_1.models.icoTransaction||!db_1.models.icoTokenOffering)throw(0,error_1.createError)({statusCode:500,message:"Model(s) missing: "+(db_1.models.icoTransaction?"":"icoTransaction ")+(db_1.models.icoTokenOffering?"":"icoTokenOffering ")});const s=db_1.models.icoTransaction,r=new Date,i=new Date(r.getFullYear(),r.getMonth(),1),n=new Date(r.getFullYear(),r.getMonth()-1,1),o=new Date(r.getFullYear(),r.getMonth(),0),[a,l,u]=await Promise.all([db_1.models.icoTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status NOT IN ('REJECTED') THEN price * amount ELSE 0 END")),"totalRaised"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${i.toISOString()}' AND status NOT IN ('REJECTED') THEN price * amount ELSE 0 END`)),"currentRaised"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${o.toISOString()}' AND status NOT IN ('REJECTED') THEN price * amount ELSE 0 END`)),"previousRaised"]],raw:!0}),db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'SUCCESS' THEN 1 ELSE 0 END")),"successfulOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${i.toISOString()}' AND status = 'SUCCESS' THEN 1 ELSE 0 END`)),"currentSuccessfulOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${o.toISOString()}' AND status = 'SUCCESS' THEN 1 ELSE 0 END`)),"previousSuccessfulOfferings"]],raw:!0}),s.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT userId")),"totalInvestors"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`DISTINCT CASE WHEN createdAt >= '${i.toISOString()}' THEN userId ELSE NULL END`)),"currentInvestors"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`DISTINCT CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${o.toISOString()}' THEN userId ELSE NULL END`)),"previousInvestors"]],raw:!0})]),c=parseFloat(null==a?void 0:a.totalRaised)||0,d=parseFloat(null==a?void 0:a.currentRaised)||0,E=parseFloat(null==a?void 0:a.previousRaised)||0,S=E>0?Math.round((d-E)/E*100):0,f=parseInt(null==l?void 0:l.successfulOfferings,10)||0,p=parseInt(null==l?void 0:l.currentSuccessfulOfferings,10)||0,I=parseInt(null==l?void 0:l.previousSuccessfulOfferings,10)||0,N=I>0?Math.round((p-I)/I*100):0,g=parseInt(null==u?void 0:u.totalInvestors,10)||0,O=parseInt(null==u?void 0:u.currentInvestors,10)||0,T=parseInt(null==u?void 0:u.previousInvestors,10)||0,v=T>0?Math.round((O-T)/T*100):0;null==t||t.success("Get ICO Stats retrieved successfully");return{projectsLaunched:f,totalRaised:c,totalInvestors:g,raisedGrowth:S,successfulOfferings:f,offeringsGrowth:N,investorsGrowth:v,averageROI:0,roiGrowth:0}};