"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.errorResponseSchema=exports.webhookEventSchema=exports.refundResponseSchema=exports.createRefundSchema=exports.paymentResponseSchema=exports.createPaymentSchema=exports.lineItemSchema=exports.urlSchema=exports.walletTypeSchema=exports.currencySchema=exports.amountSchema=exports.refundIdSchema=exports.paymentIntentIdSchema=void 0;const schema_1=require("@b/utils/schema");exports.paymentIntentIdSchema=(0,schema_1.baseStringSchema)("Unique payment intent identifier",64);exports.refundIdSchema=(0,schema_1.baseStringSchema)("Unique refund identifier",64);exports.amountSchema={type:"number",description:"Payment amount",minimum:.01};exports.currencySchema=(0,schema_1.baseStringSchema)("Currency code (e.g., USD, EUR)",20);exports.walletTypeSchema=(0,schema_1.baseEnumSchema)("Wallet type",["FIAT","SPOT","ECO"]);exports.urlSchema={type:"string",description:"A valid URL"};exports.lineItemSchema={type:"object",properties:{name:(0,schema_1.baseStringSchema)("Item name",191),description:(0,schema_1.baseStringSchema)("Item description",500,0,!0),quantity:{type:"integer",description:"Item quantity",minimum:1},unitPrice:exports.amountSchema,imageUrl:{...exports.urlSchema,description:"Item image URL"}},required:["name","quantity","unitPrice"]};exports.createPaymentSchema={type:"object",properties:{amount:exports.amountSchema,currency:exports.currencySchema,walletType:{...exports.walletTypeSchema,default:"FIAT"},merchantOrderId:(0,schema_1.baseStringSchema)("Your order reference ID",255,0,!0),description:(0,schema_1.baseStringSchema)("Payment description",1e3,0,!0),returnUrl:{...exports.urlSchema,description:"URL to redirect after successful payment"},cancelUrl:{...exports.urlSchema,description:"URL to redirect if payment is cancelled"},webhookUrl:{...exports.urlSchema,description:"URL to receive webhook notifications"},lineItems:{type:"array",items:exports.lineItemSchema,description:"List of items being purchased"},customerEmail:{type:"string",format:"email",description:"Customer email address"},customerName:(0,schema_1.baseStringSchema)("Customer name",191,0,!0),metadata:{type:"object",description:"Custom metadata for your use",additionalProperties:!0},expiresIn:{type:"integer",description:"Session expiry in seconds (default: 3600)",minimum:300,maximum:86400,default:3600}},required:["amount","currency","returnUrl"]};exports.paymentResponseSchema={type:"object",properties:{id:exports.paymentIntentIdSchema,status:(0,schema_1.baseEnumSchema)("Payment status",["PENDING","PROCESSING","COMPLETED","FAILED","CANCELLED","EXPIRED","REFUNDED","PARTIALLY_REFUNDED"]),amount:exports.amountSchema,currency:exports.currencySchema,walletType:exports.walletTypeSchema,merchantOrderId:(0,schema_1.baseStringSchema)("Merchant order ID"),description:(0,schema_1.baseStringSchema)("Payment description"),feeAmount:exports.amountSchema,netAmount:exports.amountSchema,checkoutUrl:exports.urlSchema,customerEmail:(0,schema_1.baseStringSchema)("Customer email"),customerName:(0,schema_1.baseStringSchema)("Customer name"),metadata:{type:"object",additionalProperties:!0},expiresAt:(0,schema_1.baseStringSchema)("Expiration timestamp"),completedAt:(0,schema_1.baseStringSchema)("Completion timestamp"),createdAt:(0,schema_1.baseStringSchema)("Creation timestamp")}};exports.createRefundSchema={type:"object",properties:{paymentId:exports.paymentIntentIdSchema,amount:{...exports.amountSchema,description:"Refund amount (optional, defaults to full amount)"},reason:(0,schema_1.baseEnumSchema)("Refund reason",["REQUESTED_BY_CUSTOMER","DUPLICATE","FRAUDULENT","OTHER"]),description:(0,schema_1.baseStringSchema)("Refund description",1e3,0,!0),metadata:{type:"object",description:"Custom metadata",additionalProperties:!0}},required:["paymentId"]};exports.refundResponseSchema={type:"object",properties:{id:exports.refundIdSchema,paymentId:exports.paymentIntentIdSchema,amount:exports.amountSchema,currency:exports.currencySchema,status:(0,schema_1.baseEnumSchema)("Refund status",["PENDING","COMPLETED","FAILED","CANCELLED"]),reason:(0,schema_1.baseEnumSchema)("Refund reason",["REQUESTED_BY_CUSTOMER","DUPLICATE","FRAUDULENT","OTHER"]),description:(0,schema_1.baseStringSchema)("Refund description"),createdAt:(0,schema_1.baseStringSchema)("Creation timestamp")}};exports.webhookEventSchema={type:"object",properties:{id:(0,schema_1.baseStringSchema)("Event ID"),type:(0,schema_1.baseEnumSchema)("Event type",["payment.created","payment.completed","payment.failed","payment.cancelled","payment.expired","refund.created","refund.completed","refund.failed"]),createdAt:(0,schema_1.baseStringSchema)("Event timestamp"),data:{type:"object",description:"Event data"}}};exports.errorResponseSchema={type:"object",properties:{error:{type:"object",properties:{code:(0,schema_1.baseStringSchema)("Error code"),message:(0,schema_1.baseStringSchema)("Error message")}}}};