"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),gateway_1=require("@b/utils/gateway"),utils_1=require("../utils"),console_1=require("@b/utils/console");exports.metadata={summary:"Create a payment session",description:"Creates a new payment session that customers can use to complete a payment. Returns a checkout URL to redirect customers to.",operationId:"createPayment",tags:["Gateway","Payment"],requestBody:{required:!0,content:{"application/json":{schema:utils_1.createPaymentSchema}}},responses:{201:{description:"Payment session created successfully",content:{"application/json":{schema:utils_1.paymentResponseSchema}}},400:{description:"Invalid request parameters"},401:{description:"Invalid or missing API key"},403:{description:"Insufficient permissions"}},requiresAuth:!1,logModule:"GATEWAY",logTitle:"Create Payment Session"};exports.default=async e=>{var t,a;const{body:r,headers:n,ctx:l}=e;console_1.logger.debug("GATEWAY_PAYMENT",`Payment create request received - Amount: ${null==r?void 0:r.amount}, Currency: ${null==r?void 0:r.currency}`);null==l||l.step("Authenticate API key");const s=(null==n?void 0:n["x-api-key"])||(null==n?void 0:n["X-API-Key"]),o=(null===(a=null===(t=null==n?void 0:n["x-forwarded-for"])||void 0===t?void 0:t.split(",")[0])||void 0===a?void 0:a.trim())||(null==n?void 0:n["x-real-ip"])||(null==n?void 0:n["cf-connecting-ip"])||null,{merchant:i,apiKey:c,isTestMode:u,isSecretKey:d}=await(0,gateway_1.authenticateGatewayApi)(s,o);if(!d){null==l||l.fail("Secret key required");throw(0,error_1.createError)({statusCode:403,message:"Secret key required to create payments"})}(0,gateway_1.checkApiPermission)(c,"payment.create");null==l||l.step("Validate request fields");if(!r.amount||!r.currency||!r.returnUrl){null==l||l.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: amount, currency, returnUrl"})}const m=(0,gateway_1.validateAmount)(r.amount),y=r.currency.toUpperCase();(0,gateway_1.validateCurrency)(y,i.allowedCurrencies);const p=r.walletType||"FIAT";(0,gateway_1.validateWalletType)(p,i.allowedWalletTypes);null==l||l.step("Validate against gateway settings and limits");await(0,gateway_1.validatePaymentAgainstSettings)(m,y,p);(0,gateway_1.validateUrl)(r.returnUrl,"returnUrl");r.cancelUrl&&(0,gateway_1.validateUrl)(r.cancelUrl,"cancelUrl");r.webhookUrl&&(0,gateway_1.validateUrl)(r.webhookUrl,"webhookUrl");if(m>i.transactionLimit){null==l||l.fail("Amount exceeds transaction limit");throw(0,error_1.createError)({statusCode:400,message:`Amount exceeds transaction limit of ${i.transactionLimit} ${y}`})}null==l||l.step("Calculate fees and generate payment ID");const{feeAmount:w,netAmount:g}=(0,gateway_1.calculateFees)(m,i.feeType,i.feePercentage,i.feeFixed),h=(0,gateway_1.generatePaymentIntentId)(),A=60*((await(0,gateway_1.getGatewaySettings)()).gatewayPaymentExpirationMinutes||30),_=r.expiresIn||A,I=new Date(Date.now()+1e3*_),f=(0,gateway_1.generateCheckoutUrl)(h);null==l||l.step("Create payment record");const U=await db_1.models.gatewayPayment.create({merchantId:i.id,paymentIntentId:h,merchantOrderId:r.merchantOrderId||null,amount:m,currency:y,walletType:p,feeAmount:w,netAmount:g,status:"PENDING",checkoutUrl:f,returnUrl:r.returnUrl,cancelUrl:r.cancelUrl||null,webhookUrl:r.webhookUrl||null,description:r.description||null,metadata:r.metadata||null,lineItems:r.lineItems||null,customerEmail:r.customerEmail||null,customerName:r.customerName||null,expiresAt:I,testMode:u});null==l||l.step("Send payment.created webhook");if(r.webhookUrl)try{await(0,gateway_1.sendWebhook)(i.id,U.id,null,"payment.created",r.webhookUrl,{id:`evt_${h}`,type:"payment.created",createdAt:(new Date).toISOString(),data:{id:h,merchantOrderId:r.merchantOrderId||null,amount:m,currency:y,status:"PENDING",checkoutUrl:f,expiresAt:I.toISOString()}},i.webhookSecret)}catch(e){console_1.logger.error("GATEWAY_PAYMENT","Failed to send payment.created webhook",e)}null==l||l.success("Payment created successfully");console_1.logger.success("GATEWAY_PAYMENT",`Payment created successfully - ID: ${h}, Amount: ${m} ${y}`);return{id:h,status:"PENDING",amount:m,currency:y,walletType:p,merchantOrderId:r.merchantOrderId||null,description:r.description||null,feeAmount:w,netAmount:g,checkoutUrl:f,expiresAt:I.toISOString(),createdAt:U.createdAt}};