"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize");exports.metadata={summary:"Retrieves gateway statistics",description:"Fetches public statistics for the payment gateway including total merchants, transactions, volume, and success rate.",operationId:"getGatewayStats",tags:["Gateway","Stats"],logModule:"GATEWAY",logTitle:"Get Public Stats",responses:{200:{description:"Gateway stats retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalMerchants:{type:"number",description:"Total number of registered merchants"},totalTransactions:{type:"number",description:"Total number of completed transactions"},totalVolume:{type:"number",description:"Total volume processed in millions"},successRate:{type:"number",description:"Success rate percentage"}},required:["totalMerchants","totalTransactions","totalVolume","successRate"]}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching Gateway Stats");try{const[e,s,a,r]=await Promise.all([db_1.models.gatewayMerchant.count(),db_1.models.gatewayPayment.count(),db_1.models.gatewayPayment.count({where:{status:"COMPLETED"}}),db_1.models.gatewayPayment.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],where:{status:"COMPLETED"},raw:!0})]),o=parseFloat(null==r?void 0:r.total)||0,n=s>0?Math.round(a/s*100):0,c={totalMerchants:e,totalTransactions:s,totalVolume:Math.round(o/1e6*100)/100,successRate:n};null==t||t.success(`Stats fetched: ${c.totalMerchants} merchants, ${c.totalTransactions} transactions`);return c}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving gateway stats: ${e.message}`})}};