"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Update merchant profile",description:"Updates the current user's merchant account details.",operationId:"updateMerchant",tags:["Gateway","Merchant"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string"},email:{type:"string",format:"email"},website:{type:"string",format:"uri"},description:{type:"string"},logo:{type:"string"},phone:{type:"string"},address:{type:"string"},city:{type:"string"},state:{type:"string"},country:{type:"string"},postalCode:{type:"string"},testMode:{type:"boolean"},allowedCurrencies:{type:"array",items:{type:"string"}},allowedWalletTypes:{type:"array",items:{type:"string"}},defaultCurrency:{type:"string"}}}}}},responses:{200:{description:"Merchant updated successfully"},404:{description:"Merchant not found"}},requiresAuth:!0,logModule:"GATEWAY",logTitle:"Update Merchant Profile"};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;null==a||a.step("Validate user authentication");if(!(null==t?void 0:t.id)){null==a||a.fail("Unauthorized - no user ID");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==a||a.step("Find merchant account");const s=await db_1.models.gatewayMerchant.findOne({where:{userId:t.id}});if(!s){null==a||a.fail("Merchant account not found");throw(0,error_1.createError)({statusCode:404,message:"Merchant account not found"})}null==a||a.step("Process field updates");const o=["name","email","phone","website","address","city","state","country","postalCode"],n=["description","logo","testMode","webhookUrl","successUrl","cancelUrl","allowedCurrencies","allowedWalletTypes","defaultCurrency"],l={},i="UNVERIFIED"!==s.verificationStatus;for(const e of n)void 0!==r[e]&&(l[e]=r[e]);for(const e of o)if(void 0!==r[e]){if(i&&r[e]!==s[e]){const t="VERIFIED"===s.verificationStatus?"Your account is verified.":"Your account is pending review.";throw(0,error_1.createError)({statusCode:403,message:`Cannot update ${e}. ${t} Please contact support to request changes.`})}l[e]=r[e]}null==a||a.step("Validate currencies and wallet types");if(l.allowedCurrencies&&!Array.isArray(l.allowedCurrencies))throw(0,error_1.createError)({statusCode:400,message:"allowedCurrencies must be an array"});if(l.allowedWalletTypes){if(!Array.isArray(l.allowedWalletTypes))throw(0,error_1.createError)({statusCode:400,message:"allowedWalletTypes must be an array"});const e=["FIAT","SPOT","ECO"];for(const t of l.allowedWalletTypes)if(!e.includes(t))throw(0,error_1.createError)({statusCode:400,message:`Invalid wallet type: ${t}`})}null==a||a.step("Update merchant record");await s.update(l);null==a||a.success("Merchant profile updated successfully");return{message:"Merchant updated successfully",merchant:{id:s.id,name:s.name,slug:s.slug,email:s.email,website:s.website,description:s.description,logo:s.logo,phone:s.phone,address:s.address,city:s.city,state:s.state,country:s.country,postalCode:s.postalCode,testMode:s.testMode,allowedCurrencies:s.allowedCurrencies,allowedWalletTypes:s.allowedWalletTypes,defaultCurrency:s.defaultCurrency,status:s.status,verificationStatus:s.verificationStatus,updatedAt:s.updatedAt}}};