"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Get merchant dashboard",description:"Gets the current user's merchant account details and stats.",operationId:"getMerchantDashboard",tags:["Gateway","Merchant"],parameters:[{name:"mode",in:"query",description:"Filter by mode (LIVE or TEST)",required:!1,schema:{type:"string",enum:["LIVE","TEST"]}}],responses:{200:{description:"Merchant dashboard data"},404:{description:"Merchant account not found"}},requiresAuth:!0,logModule:"GATEWAY",logTitle:"Get Merchant",demoMask:["merchant.email","merchant.phone","merchant.webhookSecret","recentPayments.customer.email"]};exports.default=async e=>{const{user:t,query:a,ctx:r}=e,s=null==a?void 0:a.mode;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching merchant dashboard data");const o=await db_1.models.gatewayMerchant.findOne({where:{userId:t.id}});if(!o)throw(0,error_1.createError)({statusCode:404,message:"Merchant account not found. Please register first."});const n=await db_1.models.gatewayMerchantBalance.findAll({where:{merchantId:o.id}}),d=new Date,l=new Date(d.getTime()-2592e6),c="TEST"===s,[u,i,m]=await Promise.all([db_1.models.gatewayPayment.findAll({where:{merchantId:o.id,status:"COMPLETED",testMode:c,completedAt:{[sequelize_1.Op.gte]:l}},attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalAmount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("feeAmount")),"totalFees"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("netAmount")),"totalNet"]],raw:!0}),db_1.models.gatewayPayment.findAll({where:{merchantId:o.id,testMode:c},order:[["createdAt","DESC"]],limit:10,attributes:["paymentIntentId","merchantOrderId","amount","currency","walletType","feeAmount","description","status","testMode","createdAt","completedAt"],include:[{model:db_1.models.user,as:"customer",attributes:["firstName","lastName","email","avatar"]}]}),db_1.models.gatewayRefund.findAll({where:{merchantId:o.id,status:"COMPLETED",createdAt:{[sequelize_1.Op.gte]:l}},attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("gatewayRefund.amount")),"totalRefunded"]],include:[{model:db_1.models.gatewayPayment,as:"payment",where:{testMode:c},attributes:[]}],raw:!0})]),p=await db_1.models.gatewayRefund.count({where:{merchantId:o.id,status:"PENDING"}}),h=u[0]||{},y=m[0]||{},w=parseFloat(h.totalAmount)||0,b=parseFloat(h.totalFees)||0,f=parseFloat(y.totalRefunded)||0,g=(parseFloat(h.totalNet)||0)-f;null==r||r.success("Request completed successfully");return{merchant:{id:o.id,name:o.name,slug:o.slug,email:o.email,phone:o.phone,logo:o.logo,website:o.website,description:o.description,businessType:o.businessType,address:o.address,city:o.city,state:o.state,country:o.country,postalCode:o.postalCode,status:o.status,verificationStatus:o.verificationStatus,testMode:o.testMode,webhookUrl:o.webhookUrl,webhookSecret:o.webhookSecret,successUrl:o.successUrl,cancelUrl:o.cancelUrl,createdAt:o.createdAt},balances:n.map(e=>({currency:e.currency,walletType:e.walletType,available:e.available,pending:e.pending,reserved:e.reserved})),stats:{last30Days:{paymentCount:parseInt(h.count)||0,totalAmount:w,totalRefunded:f,totalFees:b,totalNet:g},pendingRefunds:p},recentPayments:i.map(e=>({id:e.paymentIntentId,orderId:e.merchantOrderId,amount:e.amount,currency:e.currency,walletType:e.walletType,feeAmount:e.feeAmount,description:e.description,status:e.status,customer:e.customer?{name:`${e.customer.firstName||""} ${e.customer.lastName||""}`.trim()||e.customer.email,email:e.customer.email,avatar:e.customer.avatar}:null,createdAt:e.createdAt,completedAt:e.completedAt})),mode:s||"LIVE"}};