"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("@b/api/finance/wallet/utils");let fromBigInt,toBigIntFloat,fromBigIntMultiply,updateWalletBalance;try{const e=require("@b/api/(ext)/ecosystem/utils/blockchain");fromBigInt=e.fromBigInt;toBigIntFloat=e.toBigIntFloat;fromBigIntMultiply=e.fromBigIntMultiply;const r=require("@b/api/(ext)/ecosystem/utils/wallet");updateWalletBalance=r.updateWalletBalance}catch(e){}const query_1=require("@b/utils/query"),db_1=require("@b/db"),order_1=require("@b/api/(ext)/futures/utils/queries/order"),affiliate_1=require("@b/utils/affiliate");exports.metadata={summary:"Creates a new futures trading order",description:"Submits a new futures trading order for the logged-in user.",operationId:"createFuturesOrder",tags:["Futures","Orders"],logModule:"FUTURES",logTitle:"Create futures order",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string",description:"Currency symbol (e.g., BTC)"},pair:{type:"string",description:"Pair symbol (e.g., USDT)"},type:{type:"string",description:"Order type, e.g., limit, market"},side:{type:"string",description:"Order side, either buy or sell"},amount:{type:"number",description:"Amount of the order"},price:{type:"number",description:"Price of the order (not required for market orders)"},leverage:{type:"number",description:"Leverage for the futures order"},stopLossPrice:{type:"number",description:"Stop loss price for the order",nullable:!0},takeProfitPrice:{type:"number",description:"Take profit price for the order",nullable:!0}},required:["currency","pair","type","side","amount","leverage"]}}}},responses:(0,query_1.createRecordResponses)("Order"),requiresAuth:!0};exports.default=async e=>{var r,t,o,i,a,l,s,n,d,u,c,m,f,p,v,g,y,b,h,B,I,w,$,_,F,C,P,k,E,x,q,U,O,L,S,M,N,Y,R;const{body:T,user:W,ctx:A}=e;null===(r=null==A?void 0:A.step)||void 0===r||r.call(A,"Validating user authentication");if(!(null==W?void 0:W.id)){null===(t=null==A?void 0:A.fail)||void 0===t||t.call(A,"User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{currency:D,pair:j,amount:V,price:z,type:G,side:H,leverage:J,stopLossPrice:K,takeProfitPrice:Q}=T;null===(o=null==A?void 0:A.step)||void 0===o||o.call(A,"Validating request parameters");if(!D||!j){null===(i=null==A?void 0:A.fail)||void 0===i||i.call(A,"Invalid symbol");throw(0,error_1.createError)({statusCode:400,message:"Invalid symbol"})}const X=`${D}/${j}`;try{null===(a=null==A?void 0:A.step)||void 0===a||a.call(A,`Fetching futures market for ${X}`);const e=await db_1.models.futuresMarket.findOne({where:{currency:D,pair:j}});if(!e){null===(l=null==A?void 0:A.fail)||void 0===l||l.call(A,"Futures market data not found");throw(0,error_1.createError)({statusCode:404,message:"Futures market data not found"})}if(!e.metadata){null===(s=null==A?void 0:A.fail)||void 0===s||s.call(A,"Futures market metadata not found");throw(0,error_1.createError)({statusCode:404,message:"Futures market metadata not found"})}null===(n=null==A?void 0:A.step)||void 0===n||n.call(A,"Validating order parameters against market limits");const r=Number((null===(c=null===(u=null===(d=e.metadata)||void 0===d?void 0:d.limits)||void 0===u?void 0:u.amount)||void 0===c?void 0:c.min)||0),t=Number((null===(p=null===(f=null===(m=e.metadata)||void 0===m?void 0:m.limits)||void 0===f?void 0:f.amount)||void 0===p?void 0:p.max)||0),o=Number((null===(y=null===(g=null===(v=e.metadata)||void 0===v?void 0:v.limits)||void 0===g?void 0:g.price)||void 0===y?void 0:y.min)||0),i=Number((null===(B=null===(h=null===(b=e.metadata)||void 0===b?void 0:b.limits)||void 0===h?void 0:h.price)||void 0===B?void 0:B.max)||0),R=Number((null===($=null===(w=null===(I=e.metadata)||void 0===I?void 0:I.limits)||void 0===w?void 0:w.cost)||void 0===$?void 0:$.min)||0),T=Number((null===(C=null===(F=null===(_=e.metadata)||void 0===_?void 0:_.limits)||void 0===F?void 0:F.cost)||void 0===C?void 0:C.max)||0);if("SELL"===H&&V<r)throw(0,error_1.createError)({statusCode:400,message:`Amount is too low. You need ${r} ${D}`});if("SELL"===H&&t>0&&V>t)throw(0,error_1.createError)({statusCode:400,message:`Amount is too high. Maximum is ${t} ${D}`});if(z&&z<o)throw(0,error_1.createError)({statusCode:400,message:`Price is too low. You need ${o} ${j}`});if(i>0&&z>i)throw(0,error_1.createError)({statusCode:400,message:`Price is too high. Maximum is ${i} ${j}`});const Z=Number("BUY"===H?e.metadata.precision.amount:e.metadata.precision.price)||8,ee=Number("BUY"===H?e.metadata.taker:e.metadata.maker),re=parseFloat((V*z*ee/100).toFixed(Z)),te=V*z;if("BUY"===H&&te<R)throw(0,error_1.createError)({statusCode:400,message:`Cost is too low. You need ${R} ${j}`});if("BUY"===H&&T>0&&te>T)throw(0,error_1.createError)({statusCode:400,message:`Cost is too high. Maximum is ${T} ${j}`});null===(P=null==A?void 0:A.step)||void 0===P||P.call(A,`Fetching ${j} wallet`);const oe=await(0,utils_1.getWalletSafe)(W.id,"FUTURES",j,!1,A);if(!oe){null===(k=null==A?void 0:A.fail)||void 0===k||k.call(A,`Wallet not found for ${j}`);throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need ${te+re} ${j}`})}null===(E=null==A?void 0:A.step)||void 0===E||E.call(A,"Checking wallet balance");if(oe.balance<te+re){null===(x=null==A?void 0:A.fail)||void 0===x||x.call(A,`Insufficient balance: ${oe.balance} < ${te+re}`);throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need ${te+re} ${j}`})}null===(q=null==A?void 0:A.step)||void 0===q||q.call(A,"Checking for existing counter orders");const ie=await(0,order_1.getOrdersByUserId)(W.id);for(const e of ie)if(e.symbol===X&&e.leverage===J&&fromBigInt(e.amount)===V&&fromBigInt(e.price)===z&&e.side!==H&&"OPEN"===e.status&&fromBigInt(e.remaining)===V){null===(U=null==A?void 0:A.step)||void 0===U||U.call(A,"Counter order detected, cancelling existing order");await(0,order_1.cancelOrderByUuid)(e.userId,e.id,e.createdAt.toISOString(),X,e.price,e.side,e.remaining);null===(O=null==A?void 0:A.step)||void 0===O||O.call(A,"Refunding balance to wallet");const r=fromBigIntMultiply(e.remaining+e.fee,e.price);await updateWalletBalance(oe,r,"add");null===(L=null==A?void 0:A.success)||void 0===L||L.call(A,"Counter order closed existing position");return{message:"Counter order detected and existing position closed successfully"}}null===(S=null==A?void 0:A.step)||void 0===S||S.call(A,`Creating new ${H} order for ${V} ${D} at ${z} ${j}`);const ae=await(0,order_1.createOrder)({userId:W.id,symbol:X,amount:toBigIntFloat(V),price:toBigIntFloat(z),cost:toBigIntFloat(te),type:G,side:H,fee:toBigIntFloat(re),feeCurrency:j,leverage:J,stopLossPrice:K?toBigIntFloat(K):void 0,takeProfitPrice:Q?toBigIntFloat(Q):void 0});null===(M=null==A?void 0:A.step)||void 0===M||M.call(A,"Formatting order response");const le={...ae,amount:fromBigInt(ae.amount),price:fromBigInt(ae.price),cost:fromBigInt(ae.cost),fee:fromBigInt(ae.fee),remaining:fromBigInt(ae.remaining),leverage:J,stopLossPrice:ae.stopLossPrice?fromBigInt(ae.stopLossPrice):void 0,takeProfitPrice:ae.takeProfitPrice?fromBigInt(ae.takeProfitPrice):void 0,filled:0,average:0};null===(N=null==A?void 0:A.step)||void 0===N||N.call(A,`Deducting ${te+re} ${j} from wallet`);await updateWalletBalance(oe,te+re,"subtract");try{await(0,affiliate_1.processRewards)(W.id,te,"FUTURES_TRADE",j)}catch(e){console.error("Failed to process affiliate rewards:",e)}null===(Y=null==A?void 0:A.success)||void 0===Y||Y.call(A,`Futures order created successfully (ID: ${ae.id})`);return{message:"Futures order created successfully",order:le}}catch(e){console.error("Error creating futures order:",e);null===(R=null==A?void 0:A.fail)||void 0===R||R.call(A,`Failed to create order: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to create futures order: ${e.message}`})}};