"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const Websocket_1=require("@b/handler/Websocket"),matchingEngine_1=require("../utils/matchingEngine"),orderbook_1=require("../utils/queries/orderbook"),db_1=require("@b/db");exports.metadata={logModule:"FUTURES",logTitle:"Futures market data websocket"};class UnifiedFuturesMarketDataHandler{constructor(){this.activeSubscriptions=new Map;this.intervalMap=new Map;this.engine=null}static getInstance(){UnifiedFuturesMarketDataHandler.instance||(UnifiedFuturesMarketDataHandler.instance=new UnifiedFuturesMarketDataHandler);return UnifiedFuturesMarketDataHandler.instance}async initializeEngine(){this.engine||(this.engine=await matchingEngine_1.FuturesMatchingEngine.getInstance())}async fetchAndBroadcastData(e,t){try{await this.initializeEngine();const a=Array.from(t).map(async t=>{try{switch(t){case"orderbook":const t=await(0,orderbook_1.getOrderBook)(e);Websocket_1.messageBroker.broadcastToSubscribedClients("/api/futures/market",{type:"orderbook",symbol:e},{stream:"orderbook",data:t});break;case"trades":Websocket_1.messageBroker.broadcastToSubscribedClients("/api/futures/market",{type:"trades",symbol:e},{stream:"trades",data:[]});break;case"ticker":const a=await this.engine.getTicker(e);Websocket_1.messageBroker.broadcastToSubscribedClients("/api/futures/market",{type:"ticker",symbol:e},{stream:"ticker",data:a})}}catch(a){console.error(`Error fetching ${t} data for ${e}:`,a)}});await Promise.allSettled(a)}catch(t){console.error(`Error in fetchAndBroadcastData for ${e}:`,t)}}startDataFetching(e){this.intervalMap.has(e)&&clearInterval(this.intervalMap.get(e));const t=setInterval(async()=>{const t=this.activeSubscriptions.get(e);t&&t.size>0&&await this.fetchAndBroadcastData(e,t)},500);this.intervalMap.set(e,t)}async addSubscription(e,t){if(!e){console.warn("No symbol provided in futures subscription request");return}const[a,s]=e.split("/");if(!a||!s){console.warn(`Invalid symbol format: ${e}. Expected format: CURRENCY/PAIR`);return}if(await db_1.models.futuresMarket.findOne({where:{currency:a,pair:s,status:!0}})){if(this.activeSubscriptions.has(e))this.activeSubscriptions.get(e).add(t);else{this.activeSubscriptions.set(e,new Set([t]));this.startDataFetching(e)}await this.fetchAndBroadcastData(e,new Set([t]))}else console.warn(`Futures market ${e} not found in database or is disabled. Skipping subscription.`)}removeSubscription(e,t){if(this.activeSubscriptions.has(e)){this.activeSubscriptions.get(e).delete(t);if(0===this.activeSubscriptions.get(e).size){this.activeSubscriptions.delete(e);if(this.intervalMap.has(e)){clearInterval(this.intervalMap.get(e));this.intervalMap.delete(e)}}}}stop(){this.intervalMap.forEach(e=>clearInterval(e));this.intervalMap.clear();this.activeSubscriptions.clear()}}exports.default=async(e,t)=>{var a,s,i,r;const{ctx:n}=e;"string"==typeof t&&(t=JSON.parse(t));const{type:o,symbol:c}=t.payload;null===(a=null==n?void 0:n.step)||void 0===a||a.call(n,`Processing subscription request for ${c} (${o})`);if(!o||!c){null===(s=null==n?void 0:n.fail)||void 0===s||s.call(n,"Invalid message structure: missing type or symbol");console.error("Invalid message structure: type or symbol is missing");return}null===(i=null==n?void 0:n.step)||void 0===i||i.call(n,`Adding subscription: ${c} - ${o}`);const l=UnifiedFuturesMarketDataHandler.getInstance();await l.addSubscription(c,o);null===(r=null==n?void 0:n.success)||void 0===r||r.call(n,`Subscription added for ${c} (${o})`)};