"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const candle_1=require("@b/api/(ext)/futures/utils/queries/candle"),utils_1=require("../order/utils"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error");exports.metadata={summary:"Retrieves historical data for a specific futures symbol",description:"Fetches historical price data based on the specified interval and date range.",operationId:"getFuturesHistoricalData",tags:["Futures","Historical"],logModule:"FUTURES",logTitle:"Get futures historical data",parameters:[{name:"symbol",in:"query",required:!0,schema:{type:"string",description:"Trading symbol, e.g., BTC/USD"}},{name:"from",in:"query",required:!0,schema:{type:"number",description:"Start timestamp for historical data"}},{name:"to",in:"query",required:!0,schema:{type:"number",description:"End timestamp for historical data"}},{name:"interval",in:"query",required:!0,schema:{type:"string",description:"Time interval for the data, e.g., 1m, 5m, 1h"}}],responses:{200:{description:"Historical data retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseHistoricalDataSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Chart"),500:query_1.serverErrorResponse}};exports.default=async e=>{var r,t,a,i;const{query:s,ctx:o}=e,{symbol:l,from:n,to:u,interval:d}=s;null===(r=null==o?void 0:o.step)||void 0===r||r.call(o,"Validating request parameters");if(!n||!u||!d){null===(t=null==o?void 0:o.fail)||void 0===t||t.call(o,"Missing required parameters");throw(0,error_1.createError)({statusCode:400,message:"Both `from`, `to`, and `interval` must be provided."})}null===(a=null==o?void 0:o.step)||void 0===a||a.call(o,`Fetching historical candles for ${l}`);const c=await(0,candle_1.getHistoricalCandles)(l,d,Number(n),Number(u));null===(i=null==o?void 0:o.success)||void 0===i||i.call(o,`Retrieved ${(null==c?void 0:c.length)||0} candles`);return c};