"use strict";async function processForexInvestments(){const e="processForexInvestments",t=Date.now();try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting Forex investments processing");const a=await getActiveForexInvestments(),s=a.length;(0,broadcast_1.broadcastLog)(e,`Found ${s} active forex investments`);for(let t=0;t<s;t++){const n=a[t];(0,broadcast_1.broadcastLog)(e,`Processing forex investment id ${n.id} (current status: ${n.status})`);try{await processForexInvestment(n)?(0,broadcast_1.broadcastLog)(e,`Successfully processed forex investment id ${n.id}`,"success"):(0,broadcast_1.broadcastLog)(e,`No update for forex investment id ${n.id}`,"warning")}catch(t){console_1.logger.error("FOREX_INVESTMENT_PROCESS",`Error processing investment ${n.id}: ${t.message}`,t);(0,broadcast_1.broadcastLog)(e,`Error processing forex investment id ${n.id}: ${t.message}`,"error");continue}const o=Math.round((t+1)/s*100);(0,broadcast_1.broadcastProgress)(e,o)}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t});(0,broadcast_1.broadcastLog)(e,"Forex investments processing completed","success")}catch(t){console_1.logger.error("FOREX_INVESTMENT_PROCESS",`Forex investments processing failed: ${t.message}`,t);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Forex investments processing failed: ${t.message}`,"error");throw t}}async function getActiveForexInvestments(e){var t,a,s;try{null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Fetching active forex investments from database");const s=await db_1.models.forexInvestment.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.forexPlan,as:"plan",attributes:["id","name","title","description","defaultProfit","defaultResult","currency","walletType"]},{model:db_1.models.forexDuration,as:"duration",attributes:["id","duration","timeframe"]}],order:[["status","ASC"],["createdAt","ASC"]]});null===(a=null==e?void 0:e.success)||void 0===a||a.call(e,`Successfully fetched ${s.length} active investments`);return s}catch(t){console_1.logger.error("FOREX_INVESTMENT_PROCESS","Failed to get active forex investments",t);null===(s=null==e?void 0:e.fail)||void 0===s||s.call(e,"Failed to get active forex investments");throw t}}async function processForexInvestment(e,t=0,a){var s,n,o,r,i,l,d,c,u,v,m;const f="processForexInvestments";try{null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,`Processing forex investment ${e.id}`);if("COMPLETED"===e.status){(0,broadcast_1.broadcastLog)(f,`Investment ${e.id} is already COMPLETED; skipping`,"info");null===(n=null==a?void 0:a.step)||void 0===n||n.call(a,"Investment already completed, skipping");return null}(0,broadcast_1.broadcastLog)(f,`Fetching user for investment ${e.id}`);null===(o=null==a?void 0:a.step)||void 0===o||o.call(a,"Fetching user data");const t=await fetchUser(e.userId,a);if(!t){(0,broadcast_1.broadcastLog)(f,`User not found for investment ${e.id}`,"error");null===(r=null==a?void 0:a.fail)||void 0===r||r.call(a,"User not found");return null}const v=calculateRoi(e);(0,broadcast_1.broadcastLog)(f,`Calculated ROI (${v}) for investment ${e.id}`);null===(i=null==a?void 0:a.step)||void 0===i||i.call(a,`Calculated ROI: ${v}`);const m=determineInvestmentResult(e);(0,broadcast_1.broadcastLog)(f,`Determined result (${m}) for investment ${e.id}`);null===(l=null==a?void 0:a.step)||void 0===l||l.call(a,`Determined result: ${m}`);if(shouldProcessInvestment(e,v,m)){(0,broadcast_1.broadcastLog)(f,`Investment ${e.id} is eligible for processing (end date passed)`);null===(d=null==a?void 0:a.step)||void 0===d||d.call(a,"Investment is eligible for processing");const s=await handleInvestmentUpdate(e,t,v,m,a);s&&await postProcessInvestment(t,e,s,a);null===(c=null==a?void 0:a.success)||void 0===c||c.call(a,"Forex investment processed successfully");return s}(0,broadcast_1.broadcastLog)(f,`Investment ${e.id} is not ready for processing (end date not reached)`,"info");null===(u=null==a?void 0:a.step)||void 0===u||u.call(a,"Investment not ready for processing (end date not reached)");return null}catch(s){console_1.logger.error("FOREX_INVESTMENT_PROCESS",`Error processing investment ${e.id}: ${s.message}`,s);(0,broadcast_1.broadcastLog)(f,`Error processing investment ${e.id}: ${s.message}`,"error");null===(v=null==a?void 0:a.fail)||void 0===v||v.call(a,s.message);if(t<3){(0,broadcast_1.broadcastLog)(f,`Retrying investment ${e.id} (attempt ${t+1}/3)`,"warning");null===(m=null==a?void 0:a.step)||void 0===m||m.call(a,`Retrying (attempt ${t+1}/3)`);await new Promise(e=>setTimeout(e,1e3*Math.pow(2,t)));return processForexInvestment(e,t+1,a)}try{await db_1.models.forexInvestment.update({status:"CANCELLED",metadata:JSON.stringify({error:s.message,failedAt:(new Date).toISOString(),retries:t})},{where:{id:e.id}});(0,broadcast_1.broadcastLog)(f,`Investment ${e.id} marked as CANCELLED after 3 retries`,"error");await(0,notifications_1.createNotification)({userId:e.userId,relatedId:e.id,title:"Forex Investment Processing Failed",message:`Investment ${e.id} failed to process after 3 attempts. Manual review required.`,type:"system",link:`/admin/forex/investment/${e.id}`})}catch(e){console_1.logger.error("FOREX_INVESTMENT_PROCESS","Failed to mark investment as cancelled",e)}throw s}}async function fetchUser(e,t){var a,s,n,o;try{null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Fetching user ${e}`);const o=await db_1.models.user.findByPk(e);if(o)null===(n=null==t?void 0:t.success)||void 0===n||n.call(t,"User fetched successfully");else{console_1.logger.warn("FOREX_INVESTMENT",`User not found: ${e}`);null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,`User not found: ${e}`)}return o}catch(e){console_1.logger.error("FOREX_INVESTMENT_PROCESS","Failed to fetch user",e);null===(o=null==t?void 0:t.fail)||void 0===o||o.call(t,"Failed to fetch user");throw e}}function calculateRoi(e){var t;return null!==(t=e.profit)&&void 0!==t?t:e.plan.defaultProfit}function determineInvestmentResult(e){return e.result||e.plan.defaultResult}function shouldProcessInvestment(e){const t=calculateEndDate(e);return(0,date_fns_1.isPast)(t)}function calculateEndDate(e){const t=new Date(e.createdAt);let a;switch(e.duration.timeframe){case"HOUR":default:a=(0,date_fns_1.addHours)(t,e.duration.duration);break;case"DAY":a=(0,date_fns_1.addDays)(t,e.duration.duration);break;case"WEEK":a=(0,date_fns_1.addDays)(t,7*e.duration.duration);break;case"MONTH":a=(0,date_fns_1.addDays)(t,30*e.duration.duration)}return a}async function handleInvestmentUpdate(e,t,a,s,n){var o,r,i,l,d,c,u,v,m,f,p,g,_;const b="processForexInvestments";let I;const E=await db_1.sequelize.transaction();try{(0,broadcast_1.broadcastLog)(b,`Starting update for investment ${e.id}`);null===(o=null==n?void 0:n.step)||void 0===o||o.call(n,"Starting investment update transaction");const _=await fetchWallet(t.id,e.plan.currency,e.plan.walletType,E,n);if(!_){(0,broadcast_1.broadcastLog)(b,`Wallet not found for user ${t.id} (investment ${e.id})`,"error");null===(r=null==n?void 0:n.fail)||void 0===r||r.call(n,"Wallet not found");await E.rollback();return null}const $=null!==(i=e.amount)&&void 0!==i?i:0,w=_.balance;(0,broadcast_1.broadcastLog)(b,`Fetched wallet. Current balance: ${w}, investment amount: ${$}`);if("WIN"===s){null===(l=null==n?void 0:n.step)||void 0===l||l.call(n,"Processing WIN case - updating wallet balance");const o=`forex_invest_win_${e.id}`;await wallet_1.walletService.credit({idempotencyKey:o,userId:_.userId,walletId:_.id,walletType:e.plan.walletType,currency:e.plan.currency,amount:$+a,operationType:"FOREX_INVESTMENT_ROI",description:`Investment ROI: Plan "${e.plan.title}" | Duration: ${e.duration.duration} ${e.duration.timeframe}`,metadata:{investmentId:e.id,planId:e.plan.id,result:s,roi:a},transaction:E});(0,broadcast_1.broadcastLog)(b,`Wallet updated for WIN case. Added: ${$+a}`);(0,broadcast_1.broadcastLog)(b,`Transaction record created for WIN case for investment ${e.id}`);null===(d=null==n?void 0:n.step)||void 0===d||d.call(n,"Updating investment status to COMPLETED");await db_1.models.forexInvestment.update({status:"COMPLETED",result:s,profit:a},{where:{id:e.id},transaction:E});(0,broadcast_1.broadcastLog)(b,`Forex investment ${e.id} updated to COMPLETED (WIN)`);console_1.logger.info("FOREX_INVESTMENT_COMPLETION",`Forex investment ${e.id} completed for user ${t.id} with result: ${s}, ROI: ${a}`)}else if("LOSS"===s){null===(c=null==n?void 0:n.step)||void 0===c||c.call(n,"Processing LOSS case - calculating remaining amount");const o=Math.max(0,$-Math.abs(a));if(o>0){const t=`forex_invest_loss_${e.id}`;await wallet_1.walletService.credit({idempotencyKey:t,userId:_.userId,walletId:_.id,walletType:e.plan.walletType,currency:e.plan.currency,amount:o,operationType:"FOREX_INVESTMENT_ROI",description:`Investment ROI: Plan "${e.plan.title}" | Duration: ${e.duration.duration} ${e.duration.timeframe}`,metadata:{investmentId:e.id,planId:e.plan.id,result:s,loss:-Math.abs(a)},transaction:E})}(0,broadcast_1.broadcastLog)(b,`Wallet updated for LOSS case. Added: ${o}`);(0,broadcast_1.broadcastLog)(b,`Transaction record created for LOSS case for investment ${e.id}`);null===(u=null==n?void 0:n.step)||void 0===u||u.call(n,"Updating investment status to COMPLETED");await db_1.models.forexInvestment.update({status:"COMPLETED",result:s,profit:a},{where:{id:e.id},transaction:E});(0,broadcast_1.broadcastLog)(b,`Forex investment ${e.id} updated to COMPLETED (LOSS)`);console_1.logger.info("FOREX_INVESTMENT_COMPLETION",`Forex investment ${e.id} completed for user ${t.id} with result: ${s}, Loss: ${-Math.abs(a)}`)}else{null===(v=null==n?void 0:n.step)||void 0===v||v.call(n,"Processing DRAW case - returning original amount");const o=`forex_invest_draw_${e.id}`;await wallet_1.walletService.credit({idempotencyKey:o,userId:_.userId,walletId:_.id,walletType:e.plan.walletType,currency:e.plan.currency,amount:$,operationType:"FOREX_INVESTMENT_ROI",description:`Investment ROI: Plan "${e.plan.title}" | Duration: ${e.duration.duration} ${e.duration.timeframe}`,metadata:{investmentId:e.id,planId:e.plan.id,result:s},transaction:E});(0,broadcast_1.broadcastLog)(b,`Wallet updated for DRAW case. Returned: ${$}`);(0,broadcast_1.broadcastLog)(b,`Transaction record created for DRAW case for investment ${e.id}`);null===(m=null==n?void 0:n.step)||void 0===m||m.call(n,"Updating investment status to COMPLETED");await db_1.models.forexInvestment.update({status:"COMPLETED",result:s,profit:a},{where:{id:e.id},transaction:E});(0,broadcast_1.broadcastLog)(b,`Forex investment ${e.id} updated to COMPLETED (DRAW)`);console_1.logger.info("FOREX_INVESTMENT_COMPLETION",`Forex investment ${e.id} completed for user ${t.id} with result: ${s}, No gain or loss`)}null===(f=null==n?void 0:n.step)||void 0===f||f.call(n,"Fetching updated investment");I=await db_1.models.forexInvestment.findByPk(e.id,{include:[{model:db_1.models.forexPlan,as:"plan"},{model:db_1.models.forexDuration,as:"duration"}],transaction:E});null===(p=null==n?void 0:n.step)||void 0===p||p.call(n,"Committing transaction");await E.commit();(0,broadcast_1.broadcastLog)(b,`Transaction committed for investment ${e.id}`,"success");null===(g=null==n?void 0:n.success)||void 0===g||g.call(n,"Investment updated successfully")}catch(t){await E.rollback();(0,broadcast_1.broadcastLog)(b,`Error updating investment ${e.id}: ${t.message}`,"error");console_1.logger.error("FOREX_INVESTMENT_UPDATE","Error updating investment",t);null===(_=null==n?void 0:n.fail)||void 0===_||_.call(n,t.message);return null}return I}async function fetchWallet(e,t,a,s,n){var o,r,i,l;try{null===(o=null==n?void 0:n.step)||void 0===o||o.call(n,`Fetching wallet for user ${e} (${a} ${t})`);const l=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:a},transaction:s});if(!l){null===(r=null==n?void 0:n.fail)||void 0===r||r.call(n,"Wallet not found");throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}null===(i=null==n?void 0:n.success)||void 0===i||i.call(n,"Wallet fetched successfully");return l}catch(e){console_1.logger.error("FOREX_INVESTMENT_PROCESS","Failed to fetch wallet",e);null===(l=null==n?void 0:n.fail)||void 0===l||l.call(n,"Failed to fetch wallet");throw e}}async function postProcessInvestment(e,t,a,s){var n,o,r,i,l,d;const c="processForexInvestments";try{(0,broadcast_1.broadcastLog)(c,`Sending investment email for investment ${t.id}`);null===(n=null==s?void 0:s.step)||void 0===n||n.call(s,"Sending investment completion email");await(0,emails_1.sendInvestmentEmail)(e,t.plan,t.duration,a,"ForexInvestmentCompleted");(0,broadcast_1.broadcastLog)(c,`Investment email sent for investment ${t.id}`,"success");(0,broadcast_1.broadcastLog)(c,`Creating notification for investment ${t.id}`);null===(o=null==s?void 0:s.step)||void 0===o||o.call(s,"Creating completion notification");await(0,notifications_1.createNotification)({userId:e.id,relatedId:a.id,title:"Forex Investment Completed",message:`Your Forex investment of ${t.amount} ${t.plan.currency} has been completed with a status of ${a.result}`,type:"system",link:`/forex/investments/${a.id}`,actions:[{label:"View Investment",link:`/forex/investments/${a.id}`,primary:!0}]});(0,broadcast_1.broadcastLog)(c,`Notification created for investment ${t.id}`,"success");(0,broadcast_1.broadcastLog)(c,`Processing rewards for investment ${t.id}`);null===(r=null==s?void 0:s.step)||void 0===r||r.call(s,"Processing affiliate rewards");await(0,affiliate_1.processRewards)(e.id,null!==(i=t.amount)&&void 0!==i?i:0,"FOREX_INVESTMENT",t.plan.currency);(0,broadcast_1.broadcastLog)(c,`Rewards processed for investment ${t.id}`,"success");null===(l=null==s?void 0:s.success)||void 0===l||l.call(s,"Post-processing completed successfully")}catch(e){(0,broadcast_1.broadcastLog)(c,`Error in postProcessInvestment for ${t.id}: ${e.message}`,"error");console_1.logger.error("FOREX_INVESTMENT_POST_PROCESS",`Error in postProcessInvestment for ${t.id}: ${e.message}`,e);null===(d=null==s?void 0:s.fail)||void 0===d||d.call(s,e.message)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.processForexInvestments=processForexInvestments;exports.getActiveForexInvestments=getActiveForexInvestments;exports.processForexInvestment=processForexInvestment;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),date_fns_1=require("date-fns"),emails_1=require("@b/utils/emails"),notifications_1=require("@b/utils/notifications"),affiliate_1=require("@b/utils/affiliate"),broadcast_1=require("@b/cron/broadcast"),wallet_1=require("@b/services/wallet");