"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error"),utils_1=require("@b/api/finance/transaction/utils");exports.metadata={summary:"Lists transactions with optional filters",operationId:"listForexTransactions",tags:["User","Forex","Transactions"],parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of transactions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.baseTransactionSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transactions"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"FOREX",logTitle:"Get Forex Transactions"};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{filter:s,...a}=e.query;let o={userId:t.id};(null==s?void 0:s.includes("type"))||(o={...o,type:["FOREX_DEPOSIT","FOREX_WITHDRAW"]});null==r||r.success("Request completed successfully");return(0,query_1.getFiltered)({model:db_1.models.transaction,query:e.query,where:o,sortField:a.sortField||"createdAt",numericFields:["amount","fee"],includeModels:[{model:db_1.models.wallet,as:"wallet",attributes:["currency","type"]}]})};