"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants");exports.metadata={summary:"Get user's Forex signals",description:"Retrieves all forex signals available to the current user with pagination",operationId:"getUserForexSignals",tags:["Forex","Signals"],requiresAuth:!0,logModule:"FOREX",logTitle:"Get Forex Signals",parameters:constants_1.crudParameters,responses:{200:{description:"Forex signals retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:{id:{type:"string"},title:{type:"string"},description:{type:"string"},image:{type:"string"},status:{type:"boolean"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Signals"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:r,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{const e=await db_1.models.forexAccount.findAll({where:{userId:t.id},attributes:["id"]});if(0===e.length)return{data:[],pagination:{page:1,perPage:(null==r?void 0:r.perPage)||10,total:0,totalPages:0}};const o=e.map(e=>e.id);null==s||s.success("Request completed successfully");return(0,query_1.getFiltered)({model:db_1.models.forexSignal,query:r,where:{status:!0},sortField:(null==r?void 0:r.sortField)||"createdAt",includeModels:[{model:db_1.models.forexAccount,as:"accounts",where:{id:o},through:{attributes:[]},required:!1}]})}catch(e){console.error("Error fetching forex signals:",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}};