"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),emails_1=require("@b/utils/emails"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),console_1=require("@b/utils/console"),forex_fraud_detector_1=require("@b/api/(ext)/forex/utils/forex-fraud-detector"),affiliate_1=require("@b/utils/affiliate"),query_1=require("@b/utils/query");exports.metadata={summary:"Creates a new Forex investment",description:"Allows a user to initiate a new Forex investment.",operationId:"createForexInvestment",tags:["Forex","Investments"],requiresAuth:!0,rateLimit:{windowMs:36e5,max:10},logModule:"FOREX",logTitle:"Create forex investment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{planId:{type:"string",description:"Forex plan ID"},durationId:{type:"string",description:"Investment duration ID"},amount:{type:"number",description:"Amount to invest"},acceptTerms:{type:"boolean",description:"User must accept investment terms"}},required:["planId","durationId","amount","acceptTerms"]}}}},responses:{201:{description:"Forex investment created successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"Forex investment ID"},userId:{type:"string",description:"User ID"},planId:{type:"string",description:"Forex plan ID"},durationId:{type:"string",description:"Investment duration ID"},amount:{type:"number",description:"Investment amount"},profit:{type:"number",description:"Investment profit"},result:{type:"string",description:"Investment result (WIN, LOSS, or DRAW)"},status:{type:"string",description:"Investment status (ACTIVE, COMPLETED, CANCELLED, or REJECTED)"},endDate:{type:"string",description:"Investment end date"},createdAt:{type:"string",description:"Investment creation timestamp"},updatedAt:{type:"string",description:"Investment update timestamp"}},required:["id","userId","planId","durationId","amount","status","endDate"]}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Investment"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:r,req:n,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{planId:o,durationId:a,amount:i,acceptTerms:d}=r;try{null==s||s.step("Validating investment parameters");if(!d)throw(0,error_1.createError)({statusCode:400,message:"You must accept the investment terms and conditions to proceed"});null==s||s.step("Verifying user account");const e=await db_1.models.user.findByPk(t.id);if(!e)throw(0,error_1.createError)({statusCode:404,message:"User not found"});null==s||s.step("Fetching investment plan details");const r=await db_1.models.forexPlan.findByPk(o);if(!r)throw(0,error_1.createError)({statusCode:404,message:"Plan not found"});null==s||s.step("Validating investment amount");if(r.minAmount&&i<r.minAmount||r.maxAmount&&i>r.maxAmount)throw(0,error_1.createError)({statusCode:400,message:`Amount must be between ${r.minAmount||0} and ${r.maxAmount||"unlimited"}`});null==s||s.step("Checking forex account balance");const n=await db_1.models.forexAccount.findOne({where:{userId:t.id,type:"LIVE"}});if(!n)throw(0,error_1.createError)({statusCode:404,message:"Live account not found"});if(n.balance&&n.balance<i)throw(0,error_1.createError)({statusCode:400,message:"Insufficient balance in your account"});const u=(n.balance||0)-i;if(u<0)throw(0,error_1.createError)({statusCode:400,message:"Insufficient balance in your account"});null==s||s.step("Fetching investment duration");const c=await db_1.models.forexDuration.findByPk(a);if(!c)throw(0,error_1.createError)({statusCode:404,message:"Duration not found"});null==s||s.step("Running fraud detection checks");const m=await forex_fraud_detector_1.ForexFraudDetector.checkInvestment(t.id,i,o,s);if(!m.isValid)throw(0,error_1.createError)({statusCode:400,message:m.reason||"Investment flagged for security review"});null==s||s.step("Calculating investment end date");const l=new Date;switch(c.timeframe){case"HOUR":l.setHours(l.getHours()+c.duration);break;case"DAY":l.setDate(l.getDate()+c.duration);break;case"WEEK":l.setDate(l.getDate()+7*c.duration);break;case"MONTH":l.setDate(l.getDate()+30*c.duration);break;default:throw(0,error_1.createError)({statusCode:400,message:"Invalid timeframe"})}null==s||s.step("Creating investment record and deducting from account");const p=await db_1.sequelize.transaction(async e=>{const s=await db_1.models.forexInvestment.create({userId:t.id,planId:o,durationId:a,amount:i,status:"ACTIVE",endDate:l,termsAcceptedAt:new Date,termsVersion:"1.0"},{transaction:e});await db_1.models.forexAccount.update({balance:u},{where:{id:n.id},transaction:e});console_1.logger.info("FOREX_INVESTMENT",`User ${t.id} created forex investment ${s.id} with plan ${o}. Amount: ${i} USD, Duration: ${c.duration} ${c.timeframe}, ROI: ${r.roi}`);return s});null==s||s.step("Sending email and notification");try{await(0,emails_1.sendInvestmentEmail)(e,r,c,p,"NewForexInvestmentCreated",s);await(0,notifications_1.createNotification)({userId:t.id,relatedId:p.id,title:"New Forex Investment",message:"You have successfully created a new Forex investment.",type:"investment",link:`/forex/investment/${p.id}`,actions:[{label:"View Investment",link:`/forex/investment/${p.id}`,primary:!0}]})}catch(e){console.error("Error sending investment email:",e)}try{await(0,affiliate_1.processRewards)(t.id,i,"FOREX_INVESTMENT","USD")}catch(e){console.error("Failed to process affiliate rewards:",e)}null==s||s.success(`Created forex investment in ${r.name} for ${i} USD (${c.duration} ${c.timeframe})`);return p}catch(e){null==s||s.fail(e.message||"Failed to create forex investment");console_1.logger.error("FOREX_INVESTMENT_ERROR",`Forex investment creation failed for user ${t.id}, plan ${o}: ${e.message}. Details: planId=${o}, durationId=${a}, amount=${i}`,e);if(e.statusCode)throw e;console.error("Error creating forex investment:",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}};