"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Retrieves all Forex accounts for the logged-in user",description:"Fetches all Forex accounts associated with the currently authenticated user.",operationId:"getForexAccounts",tags:["Forex","Accounts"],logModule:"FOREX",logTitle:"Get Forex Accounts",requiresAuth:!0,responses:{200:{description:"Forex accounts retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseForexAccountSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Account"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching Forex Accounts");const s=["DEMO","LIVE"],o={};try{const e=await db_1.models.forexAccount.findAll({where:{userId:t.id},attributes:["id","accountId","broker","status","type","mt","balance","leverage","password"],include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.forexSignal,as:"accountSignals",through:{attributes:[]}}]}),r=new Set(e.map(e=>e.type));for(const u of s)if(r.has(u))o[u]=e.find(e=>e.type===u);else{const e=await db_1.models.forexAccount.findOne({where:{userId:{[sequelize_1.Op.is]:null},type:u}});let r;r=e?await db_1.models.forexAccount.update({userId:t.id,status:!0},{where:{id:e.id}}):await db_1.models.forexAccount.create({userId:t.id,type:u,status:!1});o[u]=r}}catch(e){console.error(`An error occurred while upserting Forex accounts for userId: ${t.id}`,e);throw e}null==r||r.success("Get Forex Accounts fetched successfully");return o};