"use strict";function countDecimals(e){var t;if(Number.isInteger(e))return 0;const r=e.toString();if(r.includes("e-")){const[e,t]=r.split("e-");return parseInt(t,10)}return(null===(t=r.split(".")[1])||void 0===t?void 0:t.length)||0}function sanitizeInput(e,t=255){if(!e||"string"!=typeof e)return"";let r=e.replace(/\0/g,"").replace(/[\x00-\x1F\x7F]/g,"").trim();r.length>t&&(r=r.substring(0,t));return r}function validateAddressFormat(e){if(!e||"string"!=typeof e)return!1;const t=[/[<>'"]/,/\$\{.*\}/,/\.\.\//,/__proto__|constructor|prototype/i,/javascript:/i,/data:/i,/on\w+\s*=/i,/script|iframe|object|embed/i,/union.*select/i,/exec\(|eval\(|system\(/i];for(const r of t)if(r.test(e)){console_1.logger.error("SECURITY",`Suspicious pattern detected in address: ${r}`);return!1}return/^[a-zA-Z0-9]+$/.test(e)}async function findWalletByAddress(e){const t=await db_1.models.wallet.findAll({where:{type:"ECO"}});for(const r of t){const t=(0,index_post_1.parseAddresses)(r.address);for(const a in t)if(t[a].address===e)return r}return null}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),error_1=require("@b/utils/error"),tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),query_1=require("@b/utils/query"),index_post_1=require("@b/api/finance/transfer/index.post"),withdrawalQueue_1=__importDefault(require("../utils/withdrawalQueue")),safe_imports_1=require("@b/utils/safe-imports"),console_1=require("@b/utils/console");exports.metadata={summary:"Withdraws funds to an external address",description:"Processes a withdrawal from the user's wallet to an external address.",operationId:"withdrawFunds",tags:["Wallet","Withdrawal"],requiresAuth:!0,logModule:"ECO_WITHDRAW",logTitle:"Withdraw funds to external address",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string",description:"Currency to withdraw"},chain:{type:"string",description:"Withdraw method ID"},amount:{type:"number",description:"Amount to withdraw"},toAddress:{type:"string",description:"Withdraw toAddress"}},required:["currency","chain","amount","toAddress"]}}}},responses:{200:{description:"Withdrawal processed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message indicating the withdrawal has been processed."}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Wallet"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{body:t,user:r,ctx:a}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{const{currency:e,chain:s,amount:o,toAddress:n}=t;null==a||a.step("Sanitizing input parameters");const i=sanitizeInput(e,10),l=sanitizeInput(s,20),d=sanitizeInput(n,200);null==a||a.step("Validating withdrawal request");if(!i||!l||!d){null==a||a.fail("Missing required parameters");throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters"})}if(!validateAddressFormat(d)){null==a||a.fail("Invalid address format detected");throw(0,error_1.createError)({statusCode:400,message:"Invalid address format. Address contains invalid characters or suspicious patterns."})}console_1.logger.info("ECO_WITHDRAW",`Starting withdrawal: userId=${r.id}, currency=${i}, chain=${l}, amount=${o}, toAddress=${null==d?void 0:d.substring(0,10)}...`);if(!l){console_1.logger.error("ECO_WITHDRAW","Chain parameter missing");null==a||a.fail("Chain parameter is required");throw(0,error_1.createError)({statusCode:400,message:"Chain parameter is required"})}null==a||a.step("Validating withdrawal amount");const c=parseFloat(o);if(isNaN(c)||c<=0||!isFinite(c)){null==a||a.fail("Invalid amount provided");throw(0,error_1.createError)({statusCode:400,message:"Invalid amount. Must be a positive number."})}const u=Math.abs(c);null==a||a.step("Checking if address is internal");console_1.logger.debug("ECO_WITHDRAW","Checking if address is internal...");const g=await findWalletByAddress(d);if(g){null==a||a.step("Processing as internal transfer");console_1.logger.info("ECO_WITHDRAW","Address is internal, processing as transfer");const e=await(0,index_post_1.processInternalTransfer)(r.id,g.userId,i,l,u);null==a||a.success(`Internal transfer of ${u} ${i} completed`);return e}{null==a||a.step("Processing as external withdrawal");console_1.logger.info("ECO_WITHDRAW","Address is external, processing withdrawal");const e=await storeWithdrawal(r.id,i,l,u,d,a);null==a||a.success(`Withdrawal of ${u} ${i} to ${l} submitted`);return e}}catch(e){console_1.logger.error("ECO_WITHDRAW","Error in withdrawal",e);if("INSUFFICIENT_FUNDS"===e.message){console_1.logger.debug("ECO_WITHDRAW","Insufficient funds error");null==a||a.fail("Insufficient funds");throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds"})}null==a||a.fail(`Withdrawal failed: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to withdraw: ${e}`})}};const storeWithdrawal=async(e,t,r,a,s,o)=>{var n,i,l,d,c,u,g;console_1.logger.debug("ECO_WITHDRAW",`Starting storeWithdrawal: userId=${e}, currency=${t}, chain=${r}, amount=${a}, toAddress=${null==s?void 0:s.substring(0,10)}...`);if(!r||"string"!=typeof r){console_1.logger.error("ECO_WITHDRAW",`Invalid chain parameter: ${r}`);throw(0,error_1.createError)({statusCode:400,message:"Invalid or missing chain parameter"})}null==o||o.step("Validating withdrawal address");["BTC","LTC","DOGE","DASH"].includes(r)||(0,wallet_1.validateAddress)(s,r);null==o||o.step("Retrieving user wallet");console_1.logger.debug("ECO_WITHDRAW",`Looking for wallet: userId=${e}, currency=${t}, type=ECO`);const f=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"ECO"}});if(!f){console_1.logger.error("ECO_WITHDRAW",`Wallet not found for user ${e}, currency ${t}`);throw(0,error_1.createError)({statusCode:404,message:"User wallet not found"})}if("ECO"!==f.type){console_1.logger.error("ECO_WITHDRAW",`Attempted withdrawal from non-ECO wallet: type=${f.type}`);throw(0,error_1.createError)({statusCode:403,message:"Withdrawals are only allowed from ECO wallets"})}console_1.logger.debug("ECO_WITHDRAW",`Found wallet: walletId=${f.id}, balance=${f.balance}`);null==o||o.step("Fetching token configuration");console_1.logger.debug("ECO_WITHDRAW",`Fetching token settings for ${t} on ${r}`);const w=await(0,tokens_1.getEcosystemToken)(r,t);if(!w){console_1.logger.error("ECO_WITHDRAW",`Token not found for ${t} on ${r}`);throw(0,error_1.createError)({statusCode:404,message:"Token not found"})}console_1.logger.debug("ECO_WITHDRAW",`Token found: currency=${w.currency}, decimals=${w.decimals}, precision=${w.precision}`);null==o||o.step("Validating amount precision");const p=null!==(i=null!==(n=w.precision)&&void 0!==n?n:w.decimals)&&void 0!==i?i:8,_=countDecimals(a);if(_>p)throw(0,error_1.createError)({statusCode:400,message:`Amount has too many decimal places for ${t} on ${r}. Max allowed is ${p} decimal places. Your amount has ${_} decimal places.`});null==o||o.step("Calculating withdrawal fees");let m=0;if(w.fee){const e=JSON.parse(w.fee),t=null!==(l=e.percentage)&&void 0!==l?l:0,r=null!==(d=e.min)&&void 0!==d?d:0;m=calculateWithdrawalFee(a,t,r)}let h=0,W=0;const E=["ETH","BSC","POLYGON","FTM","OPTIMISM","ARBITRUM","BASE","CELO","RSK","AVAX"].includes(r)&&"NATIVE"===w.contractType;if(E){null==o||o.step(`Estimating gas fees for ${r}`);console_1.logger.debug("ECO_WITHDRAW",`Estimating gas for NATIVE ${t} on ${r}`);try{const{initializeProvider:e}=require("@b/api/(ext)/ecosystem/utils/provider"),a=await e(r),s=await a.getFeeData(),o=21e3,{ethers:n}=require("ethers"),i=BigInt(o)*(s.gasPrice||s.maxFeePerGas||BigInt(0));W=parseFloat(n.formatUnits(i,w.decimals));console_1.logger.debug("ECO_WITHDRAW",`Estimated gas fee: ${W} ${t}, gasLimit=${o}, gasPrice=${null===(c=s.gasPrice)||void 0===c?void 0:c.toString()}`)}catch(e){console_1.logger.error("ECO_WITHDRAW",`Failed to estimate gas: ${e.message}`);W={ETH:.001,BSC:3e-4,POLYGON:.01,ARBITRUM:1e-4,OPTIMISM:1e-4,BASE:1e-4,AVAX:.001}[r]||.001;console_1.logger.debug("ECO_WITHDRAW",`Using fallback gas estimate: ${W} ${t}`)}}if(["BTC","LTC","DOGE","DASH"].includes(r)){null==o||o.step(`Validating UTXO withdrawal for ${r}`);console_1.logger.debug("ECO_WITHDRAW",`Pre-validating UTXO withdrawal for ${r}`);const{calculateMinimumWithdrawal:e}=require("@b/api/(ext)/ecosystem/utils/utxo");try{const t=await e(f.id,r,a);if(!t.isEconomical){console_1.logger.error("ECO_WITHDRAW",`Withdrawal not economical: ${t.reason}`);throw(0,error_1.createError)({statusCode:400,message:t.reason})}console_1.logger.debug("ECO_WITHDRAW",`UTXO validation passed: withdrawal requires ${t.utxoCount} UTXOs`)}catch(e){console_1.logger.error("ECO_WITHDRAW",`UTXO validation error: ${e.message}`);throw e}}else if("TRON"===r){null==o||o.step("Estimating TRON transaction fees");const e=await(0,safe_imports_1.getTronService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"Tron service not available"});const t=await e.getInstance();await t.isAddressActivated(s)||(h=1);if(!await(0,wallet_1.getWalletData)(f.id,r))throw(0,error_1.createError)({statusCode:404,message:"Wallet data not found"});const n=("string"==typeof f.address?JSON.parse(f.address):f.address)[r].address,i=Math.round(1e6*a);W=await t.estimateTransactionFee(n,s,i)/1e6}else if("XMR"===r){null==o||o.step("Estimating Monero transaction fees");const e=await(0,safe_imports_1.getMoneroService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"Monero service not available"});const t=await e.getInstance();W=await t.estimateMoneroFee()}null==o||o.step("Calculating total fees and amounts");const I=E?m+h:m+h+W,T=null!==(g=null!==(u=w.precision)&&void 0!==u?u:w.decimals)&&void 0!==g?g:8,C=parseFloat((a+I).toFixed(T));console_1.logger.debug("ECO_WITHDRAW",`Fee calculation: withdrawAmount=${a}, withdrawalFee=${m}, activationFee=${h}, estimatedNetworkFee=${W}, totalFee=${I}, totalToDeduct=${C}`);null==o||o.step("Verifying balance and creating withdrawal transaction");let b;await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.READ_COMMITTED},async e=>{const a=await db_1.models.wallet.findOne({where:{id:f.id},lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:e});if(!a)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"});const s=await db_1.models.walletData.findOne({where:{walletId:f.id,chain:r},lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:e});let o=s?parseFloat(s.balance):a.balance;if("PERMIT"===w.contractType&&s){const a=await db_1.models.ecosystemPrivateLedger.findOne({where:{walletId:f.id,index:s.index,currency:t,chain:r},transaction:e});if(a&&a.offchainDifference){const e=parseFloat(a.offchainDifference)||0;o-=e;console_1.logger.debug("ECO_WITHDRAW",`PERMIT token - adjusted for private ledger: walletDataBalance=${s.balance}, offchainDifference=${e}, adjustedAvailableBalance=${o}`)}}console_1.logger.debug("ECO_WITHDRAW",`Balance check: walletBalance=${a.balance}, walletDataBalance=${null==s?void 0:s.balance}, contractType=${w.contractType}, availableBalance=${o}, totalRequired=${C}`);if(o<C){console_1.logger.error("ECO_WITHDRAW",`Insufficient funds: available ${o} < required ${C}`);throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds"})}const n=await(0,wallet_1.decrementWalletBalance)(a,r,C,e);b=await db_1.models.transaction.findByPk(n.transactionId,{transaction:e});f.balance=a.balance-C});null==o||o.step("Adding transaction to withdrawal queue");withdrawalQueue_1.default.getInstance().addTransaction(b.id);return{transaction:b.get({plain:!0}),balance:f.balance,method:r,currency:t,message:"Withdrawal request submitted successfully",walletUpdate:{currency:t,balance:f.balance,type:"ECO"}}},calculateWithdrawalFee=(e,t,r)=>{const a=e*t/100;return Math.max(a,r)};