"use strict";async function sendEcoWithdrawalConfirmationEmail(a,e,t,i,s){const r={TO:a.email,FIRSTNAME:a.firstName,AMOUNT:e.amount.toString(),CURRENCY:t.currency,TO_ADDRESS:i,TRANSACTION_ID:e.trxId||e.id,CHAIN:s};await emails_1.emailQueue.add({emailData:r,emailType:"EcoWithdrawalConfirmation"})}async function sendEcoWithdrawalFailedEmail(a,e,t,i,s){const r={TO:a.email,FIRSTNAME:a.firstName,AMOUNT:e.amount.toString(),CURRENCY:t.currency,TO_ADDRESS:i,REASON:s};await emails_1.emailQueue.add({emailData:r,emailType:"EcoWithdrawalFailed"})}Object.defineProperty(exports,"__esModule",{value:!0});exports.sendEcoWithdrawalConfirmationEmail=sendEcoWithdrawalConfirmationEmail;exports.sendEcoWithdrawalFailedEmail=sendEcoWithdrawalFailedEmail;const db_1=require("@b/db"),utxo_1=require("@b/api/(ext)/ecosystem/utils/utxo"),notifications_1=require("@b/utils/notifications"),safe_imports_1=require("@b/utils/safe-imports"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),emails_1=require("@b/utils/emails"),withdraw_1=require("./withdraw"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class WithdrawalQueue{constructor(){this.queue=[];this.isProcessing=!1;this.processingTransactions=new Set}static getInstance(){WithdrawalQueue.instance||(WithdrawalQueue.instance=new WithdrawalQueue);return WithdrawalQueue.instance}addTransaction(a){console_1.logger.info("WITHDRAW",`Adding transaction to queue: ${a}`);if(this.processingTransactions.has(a))console_1.logger.debug("WITHDRAW",`Transaction ${a} already processing`);else if(!this.queue.includes(a)){this.queue.push(a);console_1.logger.debug("WITHDRAW",`Queue size: ${this.queue.length}`);this.processNext()}}async processNext(){if(this.isProcessing||0===this.queue.length){this.isProcessing&&console_1.logger.debug("WITHDRAW","Already processing, skipping");return}this.isProcessing=!0;const a=this.queue.shift();console_1.logger.info("WITHDRAW",`Processing transaction: ${a}`);if(a)try{this.processingTransactions.add(a);const e=await db_1.models.transaction.findOne({where:{id:a},include:[{model:db_1.models.wallet,as:"wallet",where:{type:"ECO"}}]});if(!e){console_1.logger.error("WITHDRAW",`Transaction ${a} not found`);throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"})}console_1.logger.debug("WITHDRAW",`Transaction found: id=${e.id}, type=${e.type}, status=${e.status}, amount=${e.amount}`);if(!e.wallet){console_1.logger.error("WITHDRAW",`Wallet not found for transaction ${a}`);throw(0,error_1.createError)({statusCode:404,message:"Wallet not found for transaction"})}console_1.logger.debug("WITHDRAW","Updating transaction status to PROCESSING");const[t]=await db_1.models.transaction.update({status:"PROCESSING"},{where:{id:a,status:"PENDING"}});if(0===t){console_1.logger.warn("WITHDRAW",`Transaction ${a} already processed or in process`);throw(0,error_1.createError)({statusCode:409,message:"Transaction already processed or in process"})}const i="string"==typeof e.metadata?JSON.parse(e.metadata):e.metadata;console_1.logger.debug("WITHDRAW",`Transaction metadata: chain=${null==i?void 0:i.chain}, toAddress=${null==i?void 0:i.toAddress}`);if(!i||!i.chain){console_1.logger.error("WITHDRAW",`Invalid metadata: ${JSON.stringify(i)}`);throw(0,error_1.createError)({statusCode:400,message:"Invalid or missing chain in transaction metadata"})}console_1.logger.info("WITHDRAW",`Processing withdrawal for chain: ${i.chain}`);await this.processWithdrawal(e,i);await this.sendWithdrawalConfirmationEmail(e,i);await this.recordAdminProfit(e,i)}catch(e){console_1.logger.error("WITHDRAW",`Failed to process transaction ${a}: ${e.message}`);console_1.logger.info("WITHDRAW","Marking transaction as failed");await this.markTransactionFailed(a,e.message);await new Promise(a=>setTimeout(a,1e3))}finally{this.processingTransactions.delete(a);this.isProcessing=!1;setImmediate(()=>this.processNext())}else this.isProcessing=!1}async processWithdrawal(a,e){console_1.logger.info("WITHDRAW",`processWithdrawal started for chain ${e.chain}`);if(["BTC","LTC","DOGE","DASH"].includes(e.chain))await(0,utxo_1.handleUTXOWithdrawal)(a);else if("SOL"===e.chain){const t=await(0,safe_imports_1.getSolanaService)(),i=await t.getInstance();"PERMIT"===e.contractType?await i.handleSplTokenWithdrawal(a.id,a.walletId,e.contract,a.amount,e.toAddress,e.decimals):await i.handleSolanaWithdrawal(a.id,a.walletId,a.amount,e.toAddress)}else if("TRON"===e.chain){const t=await(0,safe_imports_1.getTronService)(),i=await t.getInstance();await i.handleTronWithdrawal(a.id,a.walletId,a.amount,e.toAddress)}else if("XMR"===e.chain){const t=await(0,safe_imports_1.getMoneroService)(),i=await t.getInstance();await i.handleMoneroWithdrawal(a.id,a.walletId,a.amount,e.toAddress)}else if("TON"===e.chain){const t=await(0,safe_imports_1.getTonService)(),i=await t.getInstance();await i.handleTonWithdrawal(a.id,a.walletId,a.amount,e.toAddress)}else await(0,withdraw_1.handleEvmWithdrawal)(a.id,a.walletId,e.chain,a.amount,e.toAddress);["XMR","TRON"].includes(e.chain)||await db_1.models.transaction.update({status:"COMPLETED"},{where:{id:a.id}})}async sendWithdrawalConfirmationEmail(a,e){const t=await db_1.models.user.findOne({where:{id:a.userId}});if(t){const i=await db_1.models.wallet.findOne({where:{userId:t.id,currency:a.wallet.currency,type:"ECO"}});i&&await sendEcoWithdrawalConfirmationEmail(t,a,i,e.toAddress,e.chain)}}async recordAdminProfit(a,e){"XMR"!==e.chain&&a&&"number"==typeof a.fee&&a.fee>0&&await db_1.models.adminProfit.create({amount:a.fee,currency:a.wallet.currency,chain:e.chain,type:"WITHDRAW",transactionId:a.id,description:`Admin profit from withdrawal fee of ${a.fee} ${a.wallet.currency} for transaction (${a.id})`})}async markTransactionFailed(a,e){await db_1.models.transaction.update({status:"FAILED",description:`Transaction failed: ${e}`},{where:{id:a}});const t=await db_1.models.transaction.findByPk(a,{include:[{model:db_1.models.wallet,as:"wallet",where:{type:"ECO"}}]});if(t&&t.wallet){await(0,wallet_1.refundUser)(t);const a=await db_1.models.user.findOne({where:{id:t.userId}});if(a){const i="string"==typeof t.metadata?JSON.parse(t.metadata):t.metadata;await sendEcoWithdrawalFailedEmail(a,t,t.wallet,i.toAddress,e)}await(0,notifications_1.createNotification)({userId:t.userId,relatedId:t.id,title:"Withdrawal Failed",message:`Your withdrawal of ${t.amount} ${t.wallet.currency} has failed.`,type:"system",link:`/finance/wallet/withdrawals/${t.id}`,actions:[{label:"View Withdrawal",link:`/finance/wallet/withdrawals/${t.id}`,primary:!0}]})}}}exports.default=WithdrawalQueue;