"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.BlockCypherProvider=void 0;const console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class BlockCypherProvider{constructor(t){this.timeout=3e4;this.chain=t;this.token=process.env.BLOCKCYPHER_TOKEN;this.baseURL=this.getBaseURL(t)}getBaseURL(t){const e={BTC:`https://api.blockcypher.com/v1/btc/${"BTC"===t&&"testnet"===process.env.BTC_NETWORK?"test3":"main"}`,LTC:"https://api.blockcypher.com/v1/ltc/main",DASH:"https://api.blockcypher.com/v1/dash/main",DOGE:"https://api.blockcypher.com/v1/doge/main"};if(!e[t])throw(0,error_1.createError)({statusCode:400,message:`BlockCypher provider not available for ${t}`});return e[t]}getName(){return`BlockCypher (${this.chain})`}addToken(t){if(this.token){const e=t.includes("?")?"&":"?";return`${t}${e}token=${this.token}`}return t}async fetchFromAPI(t,e={}){const r=this.addToken(`${this.baseURL}${t}`);try{const t=await fetch(r,{...e,signal:AbortSignal.timeout(this.timeout)});if(!t.ok)throw(0,error_1.createError)({statusCode:t.status,message:`HTTP ${t.status}: ${t.statusText}`});return await t.json()}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to fetch from API",t);throw t}}async fetchTransactions(t){try{const e=await this.fetchFromAPI(`/addrs/${t}`);return Array.isArray(e.txrefs)?e.txrefs.map(t=>({hash:t.tx_hash,blockHeight:t.block_height,value:t.value,confirmedTime:t.confirmed,spent:t.spent,confirmations:t.confirmations})):[]}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to fetch transactions",t);return[]}}async fetchTransaction(t){try{const e=await this.fetchFromAPI(`/txs/${t}`),r=e.inputs.map(t=>({prev_hash:t.prev_hash,prevHash:t.prev_hash,output_index:t.output_index,outputIndex:t.output_index,output_value:t.output_value,addresses:t.addresses||[],script:t.script})),s=e.outputs.map(t=>({value:t.value,addresses:t.addresses||[],script:t.script,spent:t.spent||!1,spent_by:t.spent_by,spender:t.spent_by}));return{hash:e.hash,block_height:e.block_height,confirmations:e.confirmations,fee:e.fees,inputs:r,outputs:s}}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to fetch transaction details",t);return null}}async fetchRawTransaction(t){try{const e=await this.fetchFromAPI(`/txs/${t}?includeHex=true`);if(!e.hex)throw(0,error_1.createError)({statusCode:500,message:"Missing hex data in response"});return e.hex}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to fetch raw transaction",t);throw t}}async getBalance(t){try{const e=await this.fetchFromAPI(`/addrs/${t}/balance`);if(e.error){console_1.logger.error("BLOCKCYPHER",`Failed to get balance: ${e.error}`);return 0}return Number(e.final_balance)||0}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to get balance",t);return 0}}async getUTXOs(t){try{const e=await this.fetchFromAPI(`/addrs/${t}?unspentOnly=true`);return Array.isArray(e.txrefs)?e.txrefs.map(t=>({txid:t.tx_hash,vout:t.tx_output_n,value:t.value,confirmations:t.confirmations,script:t.script})):[]}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to get UTXOs",t);return[]}}async broadcastTransaction(t){try{const e=await this.fetchFromAPI("/txs/push",{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({tx:t})});if(!e.tx||!e.tx.hash)throw(0,error_1.createError)({statusCode:500,message:"Transaction broadcast failed: No transaction ID returned"});return{success:!0,txid:e.tx.hash}}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to broadcast transaction",t);return{success:!1,txid:null,error:t.message}}}async getFeeRate(){try{if("BTC"===this.chain){const t=await fetch("https://api.blockchain.info/mempool/fees"),e=await t.json();return e[process.env.BTC_FEE_RATE_PRIORITY||"regular"]||e.regular||1}{const t=await this.fetchFromAPI("");return(t.medium_fee_per_kb||t.medium_fee_per_kbyte)/1024}}catch(t){console_1.logger.error("BLOCKCYPHER","Failed to get fee rate",t);return 1}}async isAvailable(){try{await this.fetchFromAPI("");return!0}catch(t){return!1}}}exports.BlockCypherProvider=BlockCypherProvider;