"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,s,o){void 0===o&&(o=s);var r=Object.getOwnPropertyDescriptor(t,s);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[s]}});Object.defineProperty(e,o,r)}:function(e,t,s,o){void 0===o&&(o=s);e[o]=t[s]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&(t[t.length]=s);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var s={};if(null!=t)for(var o=e(t),r=0;r<o.length;r++)"default"!==o[r]&&__createBinding(s,t,o[r]);__setModuleDefault(s,t);return s}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.BitcoinZMQService=void 0;const zmq=__importStar(require("zeromq")),console_1=require("@b/utils/console"),btc_node_1=require("./btc-node"),db_1=require("@b/db");let storeAndBroadcastTransaction;try{const e=require("@b/api/(ext)/ecosystem/utils/redis/deposit");storeAndBroadcastTransaction=e.storeAndBroadcastTransaction}catch(e){}class BitcoinZMQService{constructor(){this.nodeService=null;this.rawTxSocket=null;this.rawBlockSocket=null;this.hashTxSocket=null;this.hashBlockSocket=null;this.watchedAddresses=new Set;this.addressToWalletId=new Map;this.processedTxIds=new Set;this.isRunning=!1;this.mempoolTxs=new Map;this.config={rawTxEndpoint:process.env.BTC_ZMQ_RAWTX||"tcp://127.0.0.1:28333",rawBlockEndpoint:process.env.BTC_ZMQ_RAWBLOCK||"tcp://127.0.0.1:28332",hashTxEndpoint:process.env.BTC_ZMQ_HASHTX||"tcp://127.0.0.1:28334",hashBlockEndpoint:process.env.BTC_ZMQ_HASHBLOCK||"tcp://127.0.0.1:28335"}}static async getInstance(){if(!BitcoinZMQService.instance){BitcoinZMQService.instance=new BitcoinZMQService;await BitcoinZMQService.instance.initialize()}return BitcoinZMQService.instance}async initialize(){try{console_1.logger.info("BTC_ZMQ","Initializing Bitcoin ZMQ service...");this.nodeService=await btc_node_1.BitcoinNodeService.getInstance();await this.startListeners();console_1.logger.success("BTC_ZMQ","Bitcoin ZMQ service initialized successfully")}catch(e){console_1.logger.error("BTC_ZMQ",`Failed to initialize: ${e.message}`);throw e}}async startListeners(){try{this.rawTxSocket=new zmq.Subscriber;this.rawTxSocket.connect(this.config.rawTxEndpoint);this.rawTxSocket.subscribe("rawtx");console_1.logger.info("BTC_ZMQ",`Connected to rawtx: ${this.config.rawTxEndpoint}`);this.rawBlockSocket=new zmq.Subscriber;this.rawBlockSocket.connect(this.config.rawBlockEndpoint);this.rawBlockSocket.subscribe("rawblock");console_1.logger.info("BTC_ZMQ",`Connected to rawblock: ${this.config.rawBlockEndpoint}`);this.hashTxSocket=new zmq.Subscriber;this.hashTxSocket.connect(this.config.hashTxEndpoint);this.hashTxSocket.subscribe("hashtx");console_1.logger.info("BTC_ZMQ",`Connected to hashtx: ${this.config.hashTxEndpoint}`);this.isRunning=!0;this.processRawTransactions();this.processRawBlocks();this.processHashTransactions();console_1.logger.success("BTC_ZMQ","All ZMQ listeners started")}catch(e){console_1.logger.error("BTC_ZMQ",`Failed to start listeners: ${e.message}`);throw e}}async processRawTransactions(){if(this.rawTxSocket)try{for await(const[e,t]of this.rawTxSocket){if(!this.isRunning)break;try{const e=t.toString("hex"),s=await this.parseRawTransaction(e);s&&await this.handleNewTransaction(s,!0)}catch(e){console_1.logger.error("BTC_ZMQ",`Error processing raw transaction: ${e.message}`)}}}catch(e){console_1.logger.error("BTC_ZMQ",`Raw transaction listener error: ${e.message}`)}}async processRawBlocks(){if(this.rawBlockSocket)try{for await(const[e,t]of this.rawBlockSocket){if(!this.isRunning)break;try{console_1.logger.info("BTC_ZMQ","New block received, updating confirmations...");await this.updatePendingTransactions();this.cleanupMempoolTxs()}catch(e){console_1.logger.error("BTC_ZMQ",`Error processing block: ${e.message}`)}}}catch(e){console_1.logger.error("BTC_ZMQ",`Raw block listener error: ${e.message}`)}}async processHashTransactions(){if(this.hashTxSocket)try{for await(const[e,t]of this.hashTxSocket){if(!this.isRunning)break;try{const e=t.toString("hex");console_1.logger.debug("BTC_ZMQ",`New transaction hash: ${e}`)}catch(e){console_1.logger.error("BTC_ZMQ",`Error processing tx hash: ${e.message}`)}}}catch(e){console_1.logger.error("BTC_ZMQ",`Hash transaction listener error: ${e.message}`)}}async parseRawTransaction(e){try{if(!this.nodeService)return null;const t=await this.nodeService.decodeRawTransaction(e);return{txid:t.txid,vout:t.vout,vin:t.vin,hex:e}}catch(e){console_1.logger.error("BTC_ZMQ",`Failed to parse raw transaction: ${e.message}`);return null}}async handleNewTransaction(e,t){var s,o,r;try{if(this.processedTxIds.has(e.txid))return;const i=[];for(let t=0;t<e.vout.length;t++){const r=e.vout[t],n=(null===(s=r.scriptPubKey)||void 0===s?void 0:s.addresses)||((null===(o=r.scriptPubKey)||void 0===o?void 0:o.address)?[r.scriptPubKey.address]:[]);for(const e of n)this.watchedAddresses.has(e)&&i.push({address:e,amount:r.value,vout:t})}if(0===i.length)return;console_1.logger.info("BTC_ZMQ",`Detected transaction to watched address: ${e.txid}`);console_1.logger.debug("BTC_ZMQ",`Matched outputs: ${JSON.stringify(i)}`);let n=0;try{const t=await(null===(r=this.nodeService)||void 0===r?void 0:r.getRawTransaction(e.txid,!0));t&&(n=t.fee?Math.abs(t.fee):0)}catch(e){}if(t){this.mempoolTxs.set(e.txid,{time:Date.now(),fee:n,addresses:i.map(e=>e.address)});console_1.logger.warn("BTC_ZMQ",`0-conf transaction detected with fee: ${n} BTC`)}for(const s of i){const o=this.addressToWalletId.get(s.address);if(!o)continue;const r=await db_1.models.wallet.findOne({where:{id:o},include:[{model:db_1.models.user,as:"user"}]});if(r&&storeAndBroadcastTransaction){const o={walletId:r.id,chain:"BTC",hash:e.txid,transactionHash:e.txid,type:t?"pending_confirmation":"DEPOSIT",from:"N/A",address:s.address,amount:s.amount,fee:n,confirmations:t?0:1,requiredConfirmations:3,status:t?"PENDING":"COMPLETED"};await storeAndBroadcastTransaction(o,e.txid,t);console_1.logger.info("BTC_ZMQ",`Broadcasted ${t?"pending":"confirmed"} transaction for wallet ${r.id}`)}}this.processedTxIds.add(e.txid);if(this.processedTxIds.size>1e3){Array.from(this.processedTxIds).slice(0,100).forEach(e=>this.processedTxIds.delete(e))}}catch(t){console_1.logger.error("BTC_ZMQ",`Error handling transaction ${e.txid}: ${t.message}`)}}async updatePendingTransactions(){var e;try{const t=await db_1.models.transaction.findAll({where:{status:"PENDING",chain:"BTC"},include:[{model:db_1.models.wallet,as:"wallet"}]});for(const s of t)try{if(!s.trxId)continue;const t=await(null===(e=this.nodeService)||void 0===e?void 0:e.getRawTransaction(s.trxId,!0));if(!t)continue;const o=t.confirmations||0;if(storeAndBroadcastTransaction){const e={walletId:s.walletId,chain:"BTC",hash:s.trxId,transactionHash:s.trxId,type:o>=3?"DEPOSIT":"pending_confirmation",from:"N/A",address:s.toAddress,amount:s.amount,fee:s.fee||0,confirmations:o,requiredConfirmations:3,status:o>=3?"COMPLETED":"PENDING"};await storeAndBroadcastTransaction(e,s.trxId,o<3);console_1.logger.info("BTC_ZMQ",`Updated transaction ${s.trxId}: ${o}/3 confirmations`)}}catch(e){console_1.logger.error("BTC_ZMQ","Error updating transaction",e)}}catch(e){console_1.logger.error("BTC_ZMQ","Error updating pending transactions",e)}}cleanupMempoolTxs(){const e=Date.now()-36e5;for(const[t,s]of this.mempoolTxs.entries())s.time<e&&this.mempoolTxs.delete(t)}async watchAddress(e,t){try{this.nodeService&&await this.nodeService.importAddress(e,`wallet_${t}`);this.watchedAddresses.add(e);this.addressToWalletId.set(e,t);console_1.logger.info("BTC_ZMQ",`Now watching address ${e} for wallet ${t}`)}catch(t){console_1.logger.error("BTC_ZMQ",`Failed to watch address ${e}: ${t.message}`);throw t}}unwatchAddress(e){this.watchedAddresses.delete(e);this.addressToWalletId.delete(e);console_1.logger.info("BTC_ZMQ",`Stopped watching address ${e}`)}getMempoolTx(e){return this.mempoolTxs.get(e)}isInMempool(e){return this.mempoolTxs.has(e)}getWatchedAddresses(){return Array.from(this.watchedAddresses)}async stop(){console_1.logger.info("BTC_ZMQ","Stopping Bitcoin ZMQ service...");this.isRunning=!1;this.rawTxSocket&&await this.rawTxSocket.close();this.rawBlockSocket&&await this.rawBlockSocket.close();this.hashTxSocket&&await this.hashTxSocket.close();this.hashBlockSocket&&await this.hashBlockSocket.close();console_1.logger.success("BTC_ZMQ","Bitcoin ZMQ service stopped")}}exports.BitcoinZMQService=BitcoinZMQService;exports.default=BitcoinZMQService;